/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.engine.Scope;
import ladybug.parse.ErrorReporter;
import ladybug.parse.PartitionType;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;
import ladybug.parse.SourceLoc;
import ladybug.parse.Type;
import ladybug.parse.TypeConflict;

public class ChainType
extends RelationType {
    public ChainType(ScalarType domain, boolean tot) {
        super(domain, domain, true, false, tot, false, false);
    }

    public ChainType(ScalarType domain) {
        super(domain, domain);
    }

    public RelationType copy() {
        return new ChainType(this.domain(), this.isTotal());
    }

    public long numValues(Scope s) {
        long sum = 1L;
        long num = 0L;
        long i = this.domain().numValues(s);
        while (i > 1L) {
            sum *= i;
            if (!this.isTotal()) {
                num += sum;
            }
            --i;
        }
        num += sum;
        if (!this.isTotal()) {
            ++num;
        }
        return num;
    }

    public int avgEdges(Scope scope) {
        if (this.isTotal()) {
            return (int)this.domain().numValues(scope);
        }
        return (int)this.domain().numValues(scope) / 2;
    }

    public int getTypeClass() {
        return 5;
    }

    public void setDomain(ScalarType domain) throws TypeConflict {
        if (this.range() != null && this.range() != domain) {
            throw new TypeConflict(domain, this.range(), "Inconsistent domain (%1) for range (%2) of chain");
        }
        super.setDomain(domain);
    }

    public void setRange(ScalarType range) throws TypeConflict {
        if (this.domain() != null && this.domain() != range) {
            throw new TypeConflict(range, this.domain(), "Inconsistent range (%1) for domain (%2) of chain");
        }
        super.setRange(range);
    }

    public boolean isChain() {
        return true;
    }

    public boolean isFunction() {
        return true;
    }

    public void setFunction(boolean func) {
        if (!func) {
            ErrorReporter.internalError(SourceLoc.noLoc, "Attempting to make a chain not a function");
        }
    }

    public boolean isInjection() {
        return false;
    }

    public void setInjection(boolean inj) {
        if (inj) {
            ErrorReporter.internalError(SourceLoc.noLoc, "Attempting to make a chain injective");
        }
    }

    public boolean isOnto() {
        return false;
    }

    public void setOnto(boolean onto) {
        if (onto) {
            ErrorReporter.internalError(SourceLoc.noLoc, "Attempting to make a chain onto");
        }
    }

    public boolean isPartitioning() {
        return false;
    }

    public void setPartitioning(PartitionType ptype) {
        ErrorReporter.internalError(SourceLoc.noLoc, "Attempting to make a chain a partitioning");
    }

    public String toString() {
        String d = this.domain() == null ? "?" : this.domain().toString();
        if (this.isTotal()) {
            return "tot chain " + d;
        }
        return "chain " + d;
    }

    public boolean equiv(Type other) {
        if (!other.isChain()) {
            return false;
        }
        ChainType ct = (ChainType)other;
        if (!(this.domain() == ct.domain() || this.domain() != null && this.domain().equiv(ct.domain()))) {
            return false;
        }
        return this.isTotal() == ct.isTotal();
    }

    public boolean includes(Type other) {
        if (other == null) {
            return false;
        }
        if (!other.isChain()) {
            return false;
        }
        ChainType ct = (ChainType)other;
        if (this.domain() != null && !this.domain().includes(ct.domain())) {
            return false;
        }
        return !this.isTotal() || ct.isTotal();
    }
}

