/*
 * Decompiled with CFR 0.152.
 */
package ladybug.parse;

import ladybug.parse.BinaryOperator;
import ladybug.parse.Clause;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.FormulaList;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Renaming;
import ladybug.parse.Schema;
import ladybug.parse.SourceLoc;
import ladybug.parse.VarEnumeration;
import ladybug.parse.VarTerm;
import ladybug.parse.Variable;

public abstract class AtomicFormula
extends Formula {
    private boolean _negated = false;
    private AtomicFormula _negFormula = null;

    public AtomicFormula(SourceLoc loc) {
        super(loc);
    }

    public boolean isNegated() {
        return this._negated;
    }

    public Formula instantiate(Schema s) {
        Renaming r = new Renaming();
        VarEnumeration ve = this.vars(s).elements();
        while (ve.hasMoreElements()) {
            Variable v = ve.nextVar();
            if (v.getSchema() == s) continue;
            Variable v2 = s.findVar(v.getName());
            if (v2 == null) {
                ErrorReporter.internalError(this.getLocation(), "Unable to instantiate formula for schema " + s.getName());
            }
            r.put(v, new VarTerm(v2, this.getLocation()));
        }
        return this.rename(r);
    }

    public FormulaList facts(Schema s) {
        return new FormulaList(this);
    }

    public void negate(SourceLoc loc) {
        this.changed();
        this._negated ^= true;
        this.location = this.location.merge(loc);
    }

    public void negate() {
        this.negate(SourceLoc.noLoc);
    }

    public Formula negated() {
        if (this._negFormula == null) {
            this._negFormula = (AtomicFormula)this.copy();
            this._negFormula.negate(SourceLoc.noLoc);
            this._negFormula._negFormula = this;
        }
        return this._negFormula;
    }

    public NormalizedFormula normalize(boolean negate) {
        NormalizedFormula nf = new NormalizedFormula();
        Clause c = new Clause(BinaryOperator.andOp());
        if (negate) {
            c.addFormula((AtomicFormula)this.negated());
        } else {
            c.addFormula((AtomicFormula)this.copy());
        }
        nf.addClause(c);
        return nf;
    }

    protected void changed() {
        if (this._negFormula != null) {
            AtomicFormula neg = this._negFormula;
            neg._negFormula = null;
            this._negFormula = null;
        }
    }
}

