/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.StringTokenizer;
import ladybug.engine.ArbTermPattern;
import ladybug.engine.BinaryTermPattern;
import ladybug.engine.EmptyTermPattern;
import ladybug.engine.IdTermPattern;
import ladybug.engine.LadyBug;
import ladybug.engine.RelDisplayPattern;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.ScalarConstPattern;
import ladybug.engine.SetDisplayPattern;
import ladybug.engine.Simplifier;
import ladybug.engine.UnaryTermPattern;
import ladybug.engine.UnivTermPattern;
import ladybug.engine.VarTermPattern;
import ladybug.parse.BinaryOperator;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.UnaryOperator;

public abstract class TermPattern {
    public abstract ReplacementEnumeration matches(Term var1);

    public abstract Term instantiate(Term[] var1, Simplifier var2);

    public abstract int numReplacements();

    public abstract String toString();

    public abstract int getTypeClass();

    public abstract TermIndex index();

    public static TermPattern parsePattern(String pat) {
        return TermPattern.parsePattern(new StringTokenizer(pat, " ()", true), null);
    }

    public static TermPattern parsePattern(StringTokenizer tokenizer, String end) {
        TermPattern right;
        TermPattern left;
        String token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        if (token.startsWith("R")) {
            left = TermPattern.parseLeaf(token.substring(1), 1, tokenizer);
        } else if (token.startsWith("S")) {
            left = TermPattern.parseLeaf(token.substring(1), 2, tokenizer);
        } else {
            if (token.startsWith("G")) {
                TermPattern left2 = TermPattern.parseLeaf(token.substring(1), 3, tokenizer);
                return TermPattern.finishParse(left2, tokenizer, end);
            }
            if (token.startsWith("I")) {
                left = TermPattern.parseLeaf(token.substring(1), 4, tokenizer);
            } else if (token.equals("{")) {
                left = TermPattern.parseDisplay(tokenizer, "}");
            } else if (token.equals("(")) {
                left = TermPattern.parsePattern(tokenizer, ")");
            } else {
                UnaryOperator uop = UnaryOperator.findOperator(token);
                if (uop != null) {
                    token = tokenizer.nextToken();
                    while (token.equals(" ")) {
                        token = tokenizer.nextToken();
                    }
                    TermPattern left3 = token.equals("(") ? TermPattern.parsePattern(tokenizer, ")") : TermPattern.parsePattern(token);
                    if (left3 == null) {
                        return null;
                    }
                    return TermPattern.finishParse(new UnaryTermPattern(uop, left3), tokenizer, end);
                }
                LadyBug.parserError("Unknown token: " + token);
                return null;
            }
        }
        if (left == null) {
            return null;
        }
        if (!tokenizer.hasMoreTokens()) {
            if (end != null) {
                LadyBug.parserError("Expected " + end + " in Term Pattern string");
                return null;
            }
            return left;
        }
        token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        if (end != null && token.equals(end)) {
            return left;
        }
        BinaryOperator bop = BinaryOperator.findOperator(token);
        if (bop == null && token.equals("$")) {
            bop = BinaryOperator.findOperator(38);
        }
        UnaryOperator uop = UnaryOperator.findOperator(token);
        if (bop == null) {
            if (uop == null) {
                LadyBug.parserError("Unexpected " + token + " in Term Pattern string");
                return null;
            }
            return TermPattern.finishParse(new UnaryTermPattern(uop, left), tokenizer, end);
        }
        if (uop != null && end == null && !tokenizer.hasMoreElements()) {
            return new UnaryTermPattern(uop, left);
        }
        token = tokenizer.nextToken();
        while (token.equals(" ") && tokenizer.hasMoreElements()) {
            token = tokenizer.nextToken();
        }
        if (uop != null && end == null && !tokenizer.hasMoreElements()) {
            return new UnaryTermPattern(uop, left);
        }
        if (uop != null && end != null && token.equals(end)) {
            return new UnaryTermPattern(uop, left);
        }
        if (token.equals("(") ? (right = TermPattern.parsePattern(tokenizer, ")")) == null : (right = TermPattern.parsePattern(token)) == null) {
            return null;
        }
        return TermPattern.finishParse(new BinaryTermPattern(bop, left, right), tokenizer, end);
    }

    public static TermPattern parseDisplay(StringTokenizer tokenizer, String end) {
        String token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        TermPattern from = token.equals("(") ? TermPattern.parsePattern(tokenizer, ")") : TermPattern.parsePattern(token);
        if (from == null) {
            return null;
        }
        if (end == null && !tokenizer.hasMoreElements()) {
            return new SetDisplayPattern(from);
        }
        token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        if (token.equals(end)) {
            return new SetDisplayPattern(from);
        }
        if (!token.equals("->")) {
            LadyBug.parserError("Expected a -> in Term Pattern string, got " + token);
            return null;
        }
        token = tokenizer.nextToken();
        while (token.equals(" ")) {
            token = tokenizer.nextToken();
        }
        TermPattern to = token.equals("(") ? TermPattern.parsePattern(tokenizer, ")") : TermPattern.parsePattern(token);
        if (to == null) {
            return null;
        }
        return TermPattern.finishParse(new RelDisplayPattern(from, to), tokenizer, end);
    }

    private static TermPattern finishParse(TermPattern tpat, StringTokenizer tokenizer, String end) {
        if (end == null) {
            if (tokenizer.hasMoreTokens()) {
                String token = tokenizer.nextToken();
                while (token.equals(" ")) {
                    token = tokenizer.nextToken();
                }
                UnaryOperator uop = UnaryOperator.findOperator(token);
                if (uop != null) {
                    return TermPattern.finishParse(new UnaryTermPattern(uop, tpat), tokenizer, end);
                }
                BinaryOperator bop = BinaryOperator.findOperator(token);
                if (bop != null) {
                    TermPattern right = TermPattern.parsePattern(tokenizer, end);
                    if (right == null) {
                        return null;
                    }
                    return new BinaryTermPattern(bop, tpat, right);
                }
                LadyBug.parserError("Unexpected " + token + " at end of Term Pattern string");
                return null;
            }
        } else {
            String token = tokenizer.nextToken();
            while (token.equals(" ")) {
                token = tokenizer.nextToken();
            }
            if (!token.equals(end)) {
                LadyBug.parserError("Expected " + end + " in Term Pattern string");
                return null;
            }
        }
        return tpat;
    }

    private static TermPattern parseLeaf(String leaf, int typeClass, StringTokenizer tokenizer) {
        if (leaf.startsWith("{}")) {
            if (typeClass != 1 && typeClass != 2) {
                LadyBug.parserError("Inconsistent typeclass for {}");
                return null;
            }
            if (leaf.length() > 2) {
                return new EmptyTermPattern(Integer.parseInt(leaf.substring(2)), typeClass);
            }
            return new EmptyTermPattern(typeClass);
        }
        if (leaf.startsWith("Id")) {
            if (typeClass != 1) {
                LadyBug.parserError("Inconsistent typeclass for Id");
                return null;
            }
            if (leaf.length() > 2) {
                return new IdTermPattern(Integer.parseInt(leaf.substring(2)));
            }
            return new IdTermPattern();
        }
        if (leaf.startsWith("Un")) {
            if (typeClass != 1 && typeClass != 2) {
                LadyBug.parserError("Inconsistent typeclass for Un");
                return null;
            }
            if (leaf.length() > 2) {
                return new UnivTermPattern(Integer.parseInt(leaf.substring(2)), typeClass);
            }
            return new UnivTermPattern(typeClass);
        }
        if (leaf.startsWith("V")) {
            return new VarTermPattern(Integer.parseInt(leaf.substring(1)), typeClass);
        }
        if (leaf.startsWith("C")) {
            if (typeClass != 4 && typeClass != 3) {
                LadyBug.parserError("Inconsistent typeclass for scalar constant");
                return null;
            }
            return new ScalarConstPattern(Integer.parseInt(leaf.substring(1)), typeClass);
        }
        return new ArbTermPattern(Integer.parseInt(leaf), typeClass);
    }
}

