/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Rule;
import ladybug.engine.RuleEnumeration;
import ladybug.engine.SimpleRuleEnum;
import ladybug.engine.TermSimplifier;
import ladybug.parse.Formula;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.Tree;

public final class Simplifier {
    private Rule[] _rules;
    private int _numRules = 0;
    private int _allocRules = 50;
    private static final int allocSize = 50;
    private Vector _terms = new Vector();
    private TermSimplifier[][] _termX;

    public Simplifier() {
        this._rules = new Rule[50];
        this._termX = new TermSimplifier[TermIndex.maxKey][];
    }

    public void addRule(Rule r) {
        if (this._numRules >= this._allocRules) {
            Rule[] old = this._rules;
            this._allocRules += 50;
            this._rules = new Rule[this._allocRules];
            int i = 0;
            while (i < this._numRules) {
                this._rules[i] = old[i];
                ++i;
            }
        }
        this._rules[this._numRules] = r;
        ++this._numRules;
    }

    public void addTermSimplifier(TermSimplifier ts) {
        this._terms.addElement(ts);
        TermIndex tx = ts.index();
        TermSimplifier[] txs = this._termX[tx.key()];
        if (txs == null) {
            txs = new TermSimplifier[50];
            this._termX[tx.key()] = txs;
            txs[0] = ts;
            return;
        }
        if (txs[txs.length - 1] != null) {
            TermSimplifier[] old = txs;
            txs = new TermSimplifier[old.length + 50];
            int i = 0;
            while (i < old.length) {
                txs[i] = old[i];
                ++i;
            }
            this._termX[tx.key()] = txs;
            txs[old.length] = ts;
            return;
        }
        int j = 0;
        while (j < txs.length) {
            if (txs[j] == null) {
                txs[j] = ts;
                return;
            }
            ++j;
        }
    }

    public RuleEnumeration rules() {
        return new SimpleRuleEnum(this._rules, this._numRules);
    }

    public Enumeration termSimplifiers() {
        return this._terms.elements();
    }

    public Term simplifyTerm(Term t) {
        TermIndex tx = t.index();
        TermSimplifier[] txs = this._termX[tx.key()];
        if (txs == null) {
            return t;
        }
        int i = 0;
        while (i < txs.length) {
            TermSimplifier ts = txs[i];
            if (ts == null) break;
            Term s = ts.simplify(t, this);
            if (s != null) {
                return this.simplifyTerm(s);
            }
            ++i;
        }
        return t;
    }

    public Formula simplifyFormula(Formula f) {
        RuleEnumeration e = this.rules();
        while (e.hasMoreElements()) {
            Rule r = e.nextRule();
            ReplacementEnumeration re = r.enablers(f, null);
            if (!re.hasMoreElements()) continue;
            return r.instantiate(re.nextReplacement(), this);
        }
        return f;
    }

    public String toString() {
        String s = "Simplifier" + Tree.linesep();
        RuleEnumeration er = this.rules();
        while (er.hasMoreElements()) {
            Rule r = er.nextRule();
            s = String.valueOf(s) + "  " + r.toString() + Tree.linesep();
        }
        Enumeration e = this.termSimplifiers();
        while (e.hasMoreElements()) {
            TermSimplifier ts = (TermSimplifier)e.nextElement();
            s = String.valueOf(s) + "  " + ts.toString() + Tree.linesep();
        }
        return String.valueOf(s) + Tree.linesep();
    }
}

