/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FactSet;
import ladybug.engine.FormulaPattern;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Rule;
import ladybug.engine.Simplifier;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.Term;

public class SimpleRule
extends Rule {
    private FormulaPattern _enabler;
    private FormulaPattern _action;
    private FormulaIndex[] _indices;
    private int num_repl;

    public SimpleRule(FormulaPattern enabler, FormulaPattern action) {
        this._enabler = enabler;
        this._action = action;
        this.num_repl = 0;
        if (enabler != null) {
            this.num_repl = enabler.numReplacements();
        }
        boolean bl = action != null && this.num_repl < action.numReplacements();
        this._indices = new FormulaIndex[1];
        this._indices[0] = enabler.index();
    }

    public ReplacementEnumeration enablers(Formula f, FactSet facts) {
        return this._enabler.matches(f);
    }

    public Formula instantiate(Term[] replacements, Simplifier s) {
        if (this._action != null) {
            Formula inst = this._action.instantiate(replacements, s);
            if (s != null) {
                return s.simplifyFormula(inst);
            }
            return inst;
        }
        return null;
    }

    public void fire(Formula f, FactSet facts, Term[] replacements, Simplifier s) {
        if (this._action != null) {
            Formula inst = this.instantiate(replacements, s);
            facts.addFact(inst);
            facts.markImpliedBy(inst, f);
        }
    }

    public FormulaIndex[] indices() {
        return this._indices;
    }

    public String toString() {
        String s = "";
        if (this._enabler != null) {
            s = this._enabler.toString();
        }
        s = String.valueOf(s) + " -> ";
        if (this._action != null) {
            s = String.valueOf(s) + this._action.toString();
        }
        return s;
    }
}

