/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.Value;
import ladybug.parse.ScalarType;
import ladybug.parse.SetType;

public final class SetValue
extends Value {
    int value;
    int maxElem;
    int min;
    ScalarType elemType;

    public SetValue(SetType ty, int max) {
        super(ty);
        this.elemType = ty.elemType();
        this.maxElem = max;
        this.init();
    }

    public SetValue(SetType ty, Scope scope) {
        this(ty, (int)ty.elemType().numValues(scope));
    }

    public Value copy() {
        SetValue sv = new SetValue((SetType)this.getType(), this.maxElem);
        sv.value = this.value;
        return sv;
    }

    public int card() {
        return Value.numbits(this.value, this.maxElem);
    }

    public void card(ScalarValue answer) {
        answer.setValue(Value.numbits(this.value, this.maxElem));
    }

    public boolean isEmpty() {
        return this.value == 0;
    }

    public int maxElem() {
        return Value.maxbit(this.value, this.maxElem);
    }

    public boolean hasElement(int i) {
        return (this.value & 1 << i) != 0;
    }

    public boolean hasElement(ScalarValue val) {
        return (this.value & 1 << val.getAdjValue()) != 0;
    }

    public void addElement(int i) {
        this.value |= 1 << i;
    }

    public void addElement(ScalarValue val) {
        this.addElement(val.getAdjValue());
    }

    public void removeElement(int i) {
        this.value &= ~(1 << i);
    }

    public void removeElement(ScalarValue val) {
        this.removeElement(val.getAdjValue());
    }

    public boolean equals(SetValue other) {
        return this.value == other.value;
    }

    public boolean equals(Value other) {
        if (other instanceof SetValue) {
            return this.equals((SetValue)other);
        }
        return false;
    }

    public boolean contains(SetValue other) {
        return (~this.value & other.value) == 0;
    }

    public boolean containsPlus(SetValue other) {
        return this.value != other.value && (~this.value & other.value) == 0;
    }

    public void union(SetValue other, SetValue answer) {
        answer.value = this.value | other.value;
    }

    public void intersect(SetValue other, SetValue answer) {
        answer.value = this.value & other.value;
    }

    public void diff(SetValue other, SetValue answer) {
        answer.value = this.value & ~other.value;
    }

    public void init() {
        this.value = 0;
    }

    public void init(SetValue sv) {
        this.value = sv.value;
    }

    public void fullSet() {
        this.value = (1 << this.maxElem) - 1;
    }

    public String toString() {
        String s = "{ ";
        boolean first = true;
        int v = this.value;
        int i = 0;
        while (v != 0) {
            if ((v & 1) == 1) {
                if (first) {
                    first = false;
                } else {
                    s = String.valueOf(s) + ", ";
                }
                s = String.valueOf(s) + this.elemType.getElementName(i);
            }
            v >>= 1;
            ++i;
        }
        return String.valueOf(s) + " }";
    }

    public int bits() {
        return this.value;
    }

    public void setBits(int bits) {
        this.value = bits;
    }

    public void addBits(int bits) {
        this.value |= bits;
    }
}

