/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.ListMatcher;
import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.ErrorReporter;
import ladybug.parse.SetDisplay;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;
import ladybug.parse.TermIndex;
import ladybug.parse.TypeConflict;

public final class SetDisplayPattern
extends TermPattern {
    private TermPattern _elem;

    public SetDisplayPattern(TermPattern elem) {
        this._elem = elem;
    }

    public ReplacementEnumeration matches(Term t) {
        if (!t.getType().isSet()) {
            return new NoMatcher();
        }
        if (!(t instanceof SetDisplay)) {
            return new NoMatcher();
        }
        SetDisplay sd = (SetDisplay)t;
        TermEnumeration e = sd.elements();
        return new ListMatcher(this._elem, sd.elements());
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        SetDisplay sd = new SetDisplay();
        try {
            sd.addElem(this._elem.instantiate(replacements, s));
            sd.updateLocation(SourceLoc.noLoc);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(SourceLoc.noLoc, tc);
        }
        return sd;
    }

    public int getTypeClass() {
        return 2;
    }

    public TermIndex index() {
        return TermIndex.createSetDispIndex(2);
    }

    public int numReplacements() {
        return this._elem.numReplacements();
    }

    public String toString() {
        return "{ " + this._elem.toString() + " }";
    }
}

