/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.LineNumberReader;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.LadyBug;
import ladybug.engine.SchemaSolver;
import ladybug.engine.Scope;
import ladybug.parse.GivenType;
import ladybug.parse.ParseError;
import ladybug.parse.Schema;
import ladybug.parse.Specification;

public class Script
implements Runnable {
    private Vector commands = new Vector();
    protected SchemaSolver solver;
    private File file;

    public Script(File sfile) {
        this.file = sfile;
        if (!sfile.exists()) {
            LadyBug.consoleMessage("Script " + sfile.getPath() + " does not exist");
            return;
        }
        if (!sfile.isFile()) {
            LadyBug.consoleMessage(String.valueOf(sfile.getPath()) + " is not a file");
            return;
        }
        if (!sfile.canRead()) {
            LadyBug.consoleMessage("Script " + sfile.getPath() + " is not readable");
            return;
        }
        try {
            LineNumberReader rdr = new LineNumberReader(new FileReader(sfile));
            if (!this.parse(rdr)) {
                this.commands = new Vector();
            }
            rdr.close();
        }
        catch (IOException ioe) {
            LadyBug.consoleMessage("Error in reading script file");
            LadyBug.consoleMessage(ioe.toString());
        }
    }

    public String getName() {
        return this.file.getName();
    }

    public File getFile() {
        return this.file;
    }

    private boolean parse(LineNumberReader rdr) throws IOException {
        while (rdr.ready()) {
            int end;
            int start;
            String line = rdr.readLine();
            if (line.startsWith("//") || line.equals("")) continue;
            if (line.startsWith("log ")) {
                this.commands.addElement(new LogCommand(line.substring(4)));
                continue;
            }
            if (line.startsWith("load ")) {
                this.commands.addElement(new LoadCommand(line.substring(5)));
                continue;
            }
            if (line.startsWith("script ")) {
                this.commands.addElement(new SourceCommand(line.substring(7)));
                continue;
            }
            if (line.equals("check")) {
                this.commands.addElement(new CheckCommand());
                continue;
            }
            if (line.startsWith("schema ")) {
                this.commands.addElement(new SchemaCommand(line.substring(7)));
                continue;
            }
            if (line.startsWith("claim ")) {
                this.commands.addElement(new SchemaCommand(line.substring(6)));
                continue;
            }
            if (line.startsWith("message ")) {
                this.commands.addElement(new MsgCommand(line.substring(8), false));
                continue;
            }
            if (line.startsWith("console ")) {
                this.commands.addElement(new MsgCommand(line.substring(8), true));
                continue;
            }
            if (line.startsWith("console ")) {
                this.commands.addElement(new MsgCommand(line.substring(8), true));
                continue;
            }
            if (line.startsWith("dump ")) {
                this.commands.addElement(new DumpCommand(line.substring(5)));
                continue;
            }
            if (line.startsWith("debug ")) {
                this.commands.addElement(new DebugCommand(line.substring(6), true));
                continue;
            }
            if (line.startsWith("nodebug ")) {
                this.commands.addElement(new DebugCommand(line.substring(8), false));
                continue;
            }
            if (line.startsWith("#")) {
                start = 1;
                while (start < line.length()) {
                    if (line.charAt(start) != ' ') break;
                    ++start;
                }
                end = start + 1;
                while (end < line.length()) {
                    if (line.charAt(end) == ' ') break;
                    ++end;
                }
                this.commands.addElement(new ScopeCommand(line.substring(start, end), Integer.parseInt(line.substring(end + 1))));
                continue;
            }
            if (line.startsWith("set ")) {
                start = 4;
                end = start + 1;
                while (end < line.length()) {
                    if (line.charAt(end) == ' ') break;
                    ++end;
                }
                this.commands.addElement(new OptionCommand(line.substring(start, end), line.substring(end + 1)));
                continue;
            }
            if (line.startsWith("toggle ")) {
                this.commands.addElement(new OptionCommand(line.substring(7), "true"));
                continue;
            }
            if (line.startsWith("untoggle ")) {
                this.commands.addElement(new OptionCommand(line.substring(9), "false"));
                continue;
            }
            LadyBug.consoleMessage("Illegal line in script: " + line);
            return false;
        }
        return true;
    }

    public void run() {
        Enumeration e = this.commands.elements();
        while (e.hasMoreElements()) {
            ScriptCommand sc = (ScriptCommand)e.nextElement();
            try {
                sc.execute();
            }
            catch (Exception ex) {
                LadyBug.consoleMessage("Script failed with " + ex.toString());
                ex.printStackTrace(System.err);
                break;
            }
        }
        LadyBug.scriptFinished(this);
    }

    void solverRun(SchemaSolver solvr) {
        this.solver = solvr;
        Enumeration e = this.commands.elements();
        while (e.hasMoreElements()) {
            ScriptCommand sc = (ScriptCommand)e.nextElement();
            try {
                sc.execute();
            }
            catch (Exception ex) {
                LadyBug.consoleMessage("Script " + this.getName() + "failed with " + ex.toString());
                ex.printStackTrace(System.err);
                break;
            }
        }
        this.solver = null;
    }

    private abstract class ScriptCommand {
        public abstract void execute() throws Exception;

        ScriptCommand() {
        }
    }

    private class LogCommand
    extends ScriptCommand {
        private File _file;

        public LogCommand(File file) {
            this._file = file;
        }

        public LogCommand(String fname) {
            this._file = new File(fname);
        }

        public void execute() throws Exception {
            LadyBug.startLogging(this._file);
        }
    }

    private class LoadCommand
    extends ScriptCommand {
        private File _file;

        public LoadCommand(File file) {
            this._file = file;
        }

        public LoadCommand(String fname) {
            this._file = new File(fname);
        }

        public void execute() throws Exception {
            LadyBug.load(this._file);
            if (LadyBug.getSpec() == null) {
                throw new ParseError("Parse failed");
            }
        }
    }

    private class SourceCommand
    extends ScriptCommand {
        private Script _scr;
        private String _fname;

        public SourceCommand(File file) {
            this._fname = file.getName();
            this._scr = new Script(file);
        }

        public SourceCommand(String fname) {
            this._fname = fname;
            this._scr = new Script(new File(fname));
        }

        public void execute() throws Exception {
            this._scr.solverRun(Script.this.solver);
        }
    }

    private class MsgCommand
    extends ScriptCommand {
        private String _msg;
        private boolean isConsole;

        public MsgCommand(String msg, boolean consoleMessage) {
            this._msg = msg;
            this.isConsole = consoleMessage;
        }

        public void execute() throws Exception {
            if (this.isConsole) {
                LadyBug.consoleMessage(this._msg);
            } else {
                LadyBug.logMessage(this._msg);
            }
        }
    }

    private class DumpCommand
    extends ScriptCommand {
        private String _comm;

        public DumpCommand(String comm) {
            this._comm = comm;
        }

        public void execute() throws Exception {
            Script.this.solver.dumpValue(this._comm);
        }
    }

    private class DebugCommand
    extends ScriptCommand {
        private String _opt;
        private boolean _val;

        public DebugCommand(String opt, boolean value) {
            this._opt = opt;
            this._val = value;
        }

        public void execute() throws Exception {
            Script.this.solver.setDebug(this._opt, this._val);
        }
    }

    private class CheckCommand
    extends ScriptCommand {
        public void execute() throws Exception {
            Script.this.solver.startSolver(true);
        }
    }

    private class SchemaCommand
    extends ScriptCommand {
        private String _name;

        public SchemaCommand(String name) {
            this._name = name;
        }

        public void execute() throws Exception {
            Specification spec;
            if (Script.this.solver != null) {
                LadyBug.solverFinished(Script.this.solver);
                Script.this.solver = null;
            }
            if ((spec = LadyBug.getSpec()) == null) {
                return;
            }
            Enumeration e = spec.schemas();
            while (e.hasMoreElements()) {
                Schema s = (Schema)e.nextElement();
                if (!s.getName().equals(this._name)) continue;
                Script.this.solver = LadyBug.findSolver(s);
                return;
            }
            LadyBug.consoleMessage("Script could not find schema " + this._name);
        }
    }

    private class ScopeCommand
    extends ScriptCommand {
        private String _tname;
        private int _bound;

        public ScopeCommand(String tname, int bound) {
            this._bound = bound;
            this._tname = tname;
        }

        public void execute() throws Exception {
            Specification spec = LadyBug.getSpec();
            if (spec == null) {
                return;
            }
            Scope scope = Script.this.solver.getScope();
            Enumeration e = spec.types();
            while (e.hasMoreElements()) {
                GivenType t = (GivenType)e.nextElement();
                if (!t.getName().equals(this._tname)) continue;
                scope.setBound(t, this._bound);
                LadyBug.scopeChanged(t);
                return;
            }
            LadyBug.consoleMessage("Type " + this._tname + " was not found for script");
        }
    }

    private class OptionCommand
    extends ScriptCommand {
        private String _option;
        private String _value;

        public OptionCommand(String option, String value) {
            this._option = option;
            this._value = value;
        }

        public void execute() throws Exception {
            if (this._option.equals("Solver")) {
                Script.this.solver.setSolverClass(this._value);
            } else if (this._option.equals("Order")) {
                Script.this.solver.setOrderClass(this._value);
            } else if (this._option.equals("LimitSearch")) {
                if (this._value.equals("all")) {
                    Script.this.solver.setUnlimitedModelsWanted(true);
                } else {
                    Script.this.solver.setNumModelsWanted(Integer.parseInt(this._value));
                }
            } else if (this._option.equals("LimitDisplay")) {
                if (this._value.equals("all")) {
                    Script.this.solver.setUnlimitedModelsToDisplay(true);
                } else {
                    Script.this.solver.setNumModelsToDisplay(Integer.parseInt(this._value));
                }
            } else {
                boolean useIt = this._value.startsWith("t") || this._value.startsWith("T");
                Script.this.solver.setToggleOption(this._option, useIt);
            }
        }
    }
}

