/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import fontanus.util.Timer;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Date;
import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.Assignment;
import ladybug.engine.AssignmentDisplay;
import ladybug.engine.DoubleScalarInfoDescr;
import ladybug.engine.ElapsedTimeInfoDescr;
import ladybug.engine.FormulaPattern;
import ladybug.engine.FormulaSolver;
import ladybug.engine.InfoDescr;
import ladybug.engine.LadyBug;
import ladybug.engine.LongScalarInfoDescr;
import ladybug.engine.MultiRule;
import ladybug.engine.RuleSuite;
import ladybug.engine.Scope;
import ladybug.engine.SimpleRule;
import ladybug.engine.Simplifier;
import ladybug.engine.SolverController;
import ladybug.engine.TermPattern;
import ladybug.engine.TermSimplifier;
import ladybug.engine.VarOrder;
import ladybug.parse.Clause;
import ladybug.parse.Formula;
import ladybug.parse.GivenType;
import ladybug.parse.NormalizedFormula;
import ladybug.parse.Schema;
import ladybug.parse.Tree;
import ladybug.util.Console;
import ladybug.util.Formatter;
import ladybug.util.ProgressorObserver;

public class SchemaSolver
implements ActionListener {
    public static final String selEnumSolverClass = "Selective Enum";
    private static final String selEnumSolverClassName = "ladybug.selenum.SelEnumSolver";
    public static final String noOrderClass = "No Ordering";
    public static final String sizeOrderClass = "Size Ordering";
    public static final String DerivedVarToggle = "Derived Vars";
    public static final String NormalizeToggle = "Normalize";
    public static final String ClosureToggle = "Conseq Closure";
    public static final String MultiClosureToggle = "Multiple Rule Closure";
    public static final String OptimDerivedToggle = "Optimize Derived";
    private FormulaSolver[] children;
    private FormulaSolver currentChild;
    private int currentChildNum;
    private boolean singleThreaded;
    private Schema _schema;
    private Scope _scope;
    private SolverController _solver;
    private String _solverClass;
    private VarOrder _order;
    private String _orderClass;
    private Formula _formula;
    private NormalizedFormula _normalized;
    private Date timeStarted;
    private Vector solutions;
    private int num_solutions;
    private int max_solutions;
    private int max_solutions_displayed;
    private int _timeOut;
    private static RuleSuite _closureRules;
    private static Simplifier _simplifier;
    private Timer _timer;
    private Console _console;
    private Console _statusConsole;
    private ProgressorObserver _progressBar;
    private AssignmentDisplay displayer;
    private boolean _useDerived;
    private boolean _normalize;
    private boolean _consClosure;
    private boolean _multiClosure;
    private boolean _optimDerived;
    private boolean _debugFacts;
    private boolean _debugConsClose;
    private boolean _debugDerived;
    private static String[] _solverClassPossibles;
    private static String[] _solverClassNames;
    private static String[] _solverClassDescrs;
    private static Class[] _solverClasses;
    static String[] orderClasses;
    static final String[] toggleOptions;
    private double _totalCases = 0.0;

    public SchemaSolver(Schema sch, Scope scope, Console console) {
        this._schema = sch;
        this._scope = scope;
        this._console = console;
        this._statusConsole = console;
        this._solver = null;
        this._progressBar = null;
        this._solverClass = selEnumSolverClass;
        this._orderClass = sizeOrderClass;
        this._debugFacts = false;
        this._debugConsClose = false;
        this._formula = null;
        this._normalized = null;
        this.solutions = null;
        this._useDerived = true;
        this._normalize = true;
        this._consClosure = true;
        this._multiClosure = false;
        this._optimDerived = true;
        this.max_solutions = 1;
        this.max_solutions_displayed = 1;
        this._timeOut = -30000;
        this.displayer = null;
        this.children = null;
        this.currentChild = null;
        this.currentChildNum = 0;
        this.timeStarted = null;
        this._timer = null;
        this.createChildren();
    }

    public void setProgressorObserver(ProgressorObserver pbar) {
        this._progressBar = pbar;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setProgressorObserver(pbar);
            ++i;
        }
    }

    public void setConsole(Console console) {
        this._statusConsole = console;
    }

    public Schema getSchema() {
        return this._schema;
    }

    public String getSchemaText() {
        return this.getSchema().toString();
    }

    public Scope getScope() {
        return this._scope;
    }

    public synchronized void scopeChanged(GivenType gt) {
        if (!this.getSchema().usesType(gt)) {
            return;
        }
        int i = 0;
        while (i < this.children.length) {
            this.children[i].scopeChanged(gt);
            ++i;
        }
        this._totalCases = 0.0;
    }

    public synchronized AssignmentDisplay getAssignmentDisplay() {
        if (this.currentChild == null) {
            return null;
        }
        if (this.displayer == null) {
            this.displayer = new AssignmentDisplay(this.currentChild);
        }
        return this.displayer;
    }

    public boolean dumpValue(String command) {
        boolean first = true;
        int i = 0;
        while (i < this.children.length) {
            if (!this.children[i].getSolver().dumpOptions().dumpValue(first, command)) {
                return false;
            }
            first = false;
            ++i;
        }
        return true;
    }

    public String[] dumpCommands(boolean detailed) {
        if (this._solver == null) {
            return new String[0];
        }
        if (detailed) {
            return this._solver.dumpOptions().allDumpCommands();
        }
        return this._solver.dumpOptions().basicDumpCommands();
    }

    public boolean getDebug(String option) {
        if (this._solver == null) {
            return false;
        }
        return this._solver.debugOptions().getDebug(option);
    }

    public boolean setDebug(String option, boolean value) {
        boolean result = true;
        int i = 0;
        while (i < this.children.length) {
            if (!this.children[i].getSolver().debugOptions().setDebug(option, value)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public boolean toggleDebug(String option) {
        boolean result = true;
        int i = 0;
        while (i < this.children.length) {
            if (!this.children[i].getSolver().debugOptions().setDebug(option, this.children[i].getSolver().debugOptions().getDebug(option) ^ true)) {
                result = false;
            }
            ++i;
        }
        return result;
    }

    public String[] debugOptions() {
        if (this._solver == null) {
            return new String[0];
        }
        return this._solver.debugOptions().debugOptions();
    }

    public InfoDescr[] statusInfo() {
        InfoDescr[] basicDescrs = new InfoDescr[]{new 1("Total Cases", "9,999,999,999"), new 2("Time", "00:00:00.0"), new 3(String.valueOf(this.getModelName()) + "s", "99,999,999")};
        if (this._solver == null) {
            return basicDescrs;
        }
        return this._solver.statusInfo(basicDescrs);
    }

    public Formula getFormula() {
        if (this._formula != null) {
            return this._formula;
        }
        this._formula = this._schema.formula();
        if (this._normalize) {
            this._normalized = this._formula.normalize(this._schema.isClaim());
            this._formula = this._normalized;
            return this._normalized;
        }
        if (this._schema.isClaim()) {
            this._formula = this._formula.negated();
        }
        return this._formula;
    }

    public String dumpClauses() {
        if (!this._normalize) {
            return String.valueOf(this._formula.toString()) + Tree.linesep() + "(Normalization is disabled)";
        }
        this.getFormula();
        return this._normalized.toString();
    }

    public SolverController currentSolver() {
        return this._solver;
    }

    public String currentSolverClass() {
        return this._solverClass;
    }

    public synchronized void setSolverClass(String sclass) {
        this._solver = null;
        this._solverClass = sclass;
        this.createChildren();
    }

    public synchronized String[] solverClasses() {
        if (_solverClassDescrs == null) {
            Class[] classes = new Class[_solverClassPossibles.length];
            int numMissing = 0;
            int i = 0;
            while (i < _solverClassPossibles.length) {
                try {
                    classes[i] = Class.forName(_solverClassNames[i]);
                }
                catch (ClassNotFoundException classNotFoundException) {
                    ++numMissing;
                    classes[i] = null;
                }
                ++i;
            }
            if (numMissing == 0) {
                _solverClassDescrs = _solverClassPossibles;
                _solverClasses = classes;
            } else {
                _solverClassDescrs = new String[_solverClassPossibles.length - numMissing];
                _solverClasses = new Class[_solverClassPossibles.length - numMissing];
                int j = 0;
                i = 0;
                while (i < _solverClassPossibles.length) {
                    if (classes[i] != null) {
                        SchemaSolver._solverClasses[i] = classes[j];
                        SchemaSolver._solverClassDescrs[i] = _solverClassPossibles[j];
                        ++j;
                    }
                    ++i;
                }
                if (_solverClassPossibles.length == numMissing) {
                    LadyBug.consoleMessage(this._console, "No solver methods available");
                }
            }
        }
        return _solverClassDescrs;
    }

    public String currentOrderClass() {
        return this._orderClass;
    }

    public synchronized void setOrderClass(String oclass) {
        if (oclass.equals(this._orderClass)) {
            return;
        }
        this._orderClass = oclass;
        int i = 0;
        while (i < this.children.length) {
            if (this.children[i] != null) {
                this.children[i].setOrderClass(oclass);
            }
            ++i;
        }
    }

    public String[] getOrderClasses() {
        if (this._solver == null) {
            return orderClasses;
        }
        return this._solver.getVarOrderings();
    }

    public double totalCases() {
        if (this._totalCases == 0.0) {
            int i = 0;
            while (i < this.children.length) {
                this._totalCases += this.children[i].totalCases();
                ++i;
            }
        }
        return this._totalCases;
    }

    public Enumeration models() {
        return this.solutions.elements();
    }

    public Date solverStarted() {
        return this.timeStarted;
    }

    public long elapsedTime() {
        long etime = 0L;
        int i = 0;
        while (i < this.currentChildNum) {
            etime += this.children[i].elapsedTime();
            ++i;
        }
        return etime;
    }

    public int numModelsFound() {
        return this.num_solutions;
    }

    public int numModelsWanted() {
        return Math.abs(this.max_solutions);
    }

    public void setNumModelsWanted(int max) {
        this.max_solutions = max;
    }

    public void setUnlimitedModelsWanted(boolean nolimit) {
        if (nolimit) {
            if (this.max_solutions < 0) {
                return;
            }
            this.max_solutions *= -1;
        } else {
            if (this.max_solutions > 0) {
                return;
            }
            this.max_solutions *= -1;
        }
    }

    public boolean getUnlimitedModelsWanted() {
        return this.max_solutions < 0;
    }

    public int numModelsToDisplay() {
        return Math.abs(this.max_solutions_displayed);
    }

    public void setNumModelsToDisplay(int max) {
        this.max_solutions_displayed = max;
    }

    public void setUnlimitedModelsToDisplay(boolean nolimit) {
        if (nolimit) {
            if (this.max_solutions_displayed < 0) {
                return;
            }
            this.max_solutions_displayed *= -1;
        } else {
            if (this.max_solutions_displayed > 0) {
                return;
            }
            this.max_solutions_displayed *= -1;
        }
    }

    public boolean getUnlimitedModelsToDisplay() {
        return this.max_solutions_displayed < 0;
    }

    public void setTimeout(int msecs) {
        this._timeOut = msecs;
        this.getTimer().setDelay(msecs);
        this._timer.start();
    }

    public int getTimeout() {
        return Math.abs(this._timeOut);
    }

    public void setUnlimitedTimeout(boolean nolimit) {
        if (nolimit) {
            if (this._timeOut < 0) {
                return;
            }
            this._timeOut *= -1;
            if (this._timer != null) {
                this._timer.stop();
            }
        } else {
            if (this._timeOut > 0) {
                return;
            }
            this._timeOut = this._timeOut == 0 ? 1000 : (this._timeOut *= -1);
            this.getTimer().start();
        }
    }

    public boolean getUnlimitedTimeout() {
        return this._timeOut < 0;
    }

    public Timer getTimer() {
        if (this._timer == null) {
            this._timer = new Timer(this.getTimeout(), "Timeout");
            this._timer.addActionListener(this);
        }
        return this._timer;
    }

    public void actionPerformed(ActionEvent ae) {
        String command = ae.getActionCommand();
        if (command.equals("Timeout")) {
            this.haltSolver();
            this._timer.stop();
        }
    }

    public boolean useDerivedVars() {
        return this._useDerived;
    }

    public void setUseDerivedVars(boolean useIt) {
        if (this._useDerived == useIt) {
            return;
        }
        this._useDerived = useIt;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setUseDerivedVars(useIt);
            ++i;
        }
    }

    public boolean optimDerivedVars() {
        return this._optimDerived;
    }

    public void setOptimDerivedVars(boolean doIt) {
        if (this._optimDerived == doIt) {
            return;
        }
        this._optimDerived = doIt;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setOptimDerivedVars(doIt);
            ++i;
        }
    }

    public boolean useNormalize() {
        return this._normalize;
    }

    public void setUseNormalize(boolean useIt) {
        if (this._normalize == useIt) {
            return;
        }
        this._normalize = useIt;
        this._formula = null;
        this.createChildren();
    }

    public boolean useConsClosure() {
        return this._consClosure;
    }

    public void setUseConsClosure(boolean useIt) {
        if (this._consClosure == useIt) {
            return;
        }
        this._consClosure = useIt;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setUseConsClosure(useIt);
            ++i;
        }
    }

    public boolean useMultiClosure() {
        return this._multiClosure;
    }

    public synchronized void setUseMultiClosure(boolean useIt) {
        if (this._multiClosure == useIt) {
            return;
        }
        this._multiClosure = useIt;
        _closureRules = null;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setUseConsClosure(useIt);
            ++i;
        }
    }

    void setDebugFacts(boolean debugIt) {
        if (this._debugFacts == debugIt) {
            return;
        }
        this._debugFacts = debugIt;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setDebugFacts(debugIt);
            ++i;
        }
    }

    public void setDebugConsClose(boolean debugIt) {
        if (this._debugConsClose == debugIt) {
            return;
        }
        this._debugConsClose = debugIt;
        if (_closureRules != null) {
            _closureRules.setDebugRules(debugIt);
        }
    }

    public void setDebugDerived(boolean debugIt) {
        if (this._debugDerived == debugIt) {
            return;
        }
        this._debugDerived = debugIt;
        int i = 0;
        while (i < this.children.length) {
            this.children[i].setDebugDerived(debugIt);
            ++i;
        }
    }

    boolean getDebugFacts() {
        return this._debugFacts;
    }

    public boolean getDebugConsClose() {
        return this._debugConsClose;
    }

    public boolean getDebugDerived() {
        return this._debugDerived;
    }

    public void setToggleOption(String option, boolean value) {
        if (option.equals(DerivedVarToggle)) {
            this.setUseDerivedVars(value);
        } else if (option.equals(NormalizeToggle)) {
            this.setUseNormalize(value);
        } else if (option.equals(ClosureToggle)) {
            this.setUseConsClosure(value);
        } else if (option.equals(MultiClosureToggle)) {
            this.setUseConsClosure(value);
        } else if (option.equals(OptimDerivedToggle)) {
            this.setOptimDerivedVars(value);
        } else {
            int i = 0;
            while (i < this.children.length) {
                this.children[i].getSolver().setToggleOption(option, value);
                ++i;
            }
        }
    }

    public boolean getToggleOption(String option) {
        if (option.equals(DerivedVarToggle)) {
            return this.useDerivedVars();
        }
        if (option.equals(NormalizeToggle)) {
            return this.useNormalize();
        }
        if (option.equals(ClosureToggle)) {
            return this.useConsClosure();
        }
        if (option.equals(MultiClosureToggle)) {
            return this.useMultiClosure();
        }
        if (option.equals(OptimDerivedToggle)) {
            return this.optimDerivedVars();
        }
        if (this._solver == null) {
            return false;
        }
        return this._solver.getToggleOption(option);
    }

    public String[] getToggleOptions() {
        if (this._solver == null) {
            return toggleOptions;
        }
        return this._solver.getToggleOptions();
    }

    synchronized RuleSuite getClosureRules() {
        if (!this.useConsClosure()) {
            return null;
        }
        if (_closureRules == null) {
            _closureRules = new RuleSuite("Consequence Closure", this._debugConsClose, this.getSimplifier());
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S1 = S0"), FormulaPattern.parsePattern("S1 <= S0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R1 = R0"), FormulaPattern.parsePattern("R1 <= R0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S1 < S0"), FormulaPattern.parsePattern("S1 <= S0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R1 < R0"), FormulaPattern.parsePattern("R1 <= R0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("{ G0 } <= S1"), FormulaPattern.parsePattern("G0 in S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("not { G0 } <= S1"), FormulaPattern.parsePattern("not G0 in S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("seq (R0)"), FormulaPattern.parsePattern("(ran R0) <= (dom R0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(first R0) in S1"), FormulaPattern.parsePattern("not (S1 & (dom R0)) = S{}")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(last R0) in S1"), FormulaPattern.parsePattern("not (S1 & (dom R0)) = S{}")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(last R0) in S1"), FormulaPattern.parsePattern("not (S1 & (ran R0)) = S{}")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("not G0 in (S1 U S2)"), FormulaPattern.parsePattern("not G0 in S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("G0 in (S1 & S2)"), FormulaPattern.parsePattern("G0 in S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("not G0 in { G1 }"), FormulaPattern.parsePattern("not G0 = G1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(S1 U S2) <= S0"), FormulaPattern.parsePattern("S1 <= S0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(R1 U R2) <= R0"), FormulaPattern.parsePattern("R1 <= R0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("not S0 <= (S1 U S2)"), FormulaPattern.parsePattern("not S0 <= S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("not R0 <= (R1 U R2)"), FormulaPattern.parsePattern("not R0 <= R1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(S1 U S2) = S0"), FormulaPattern.parsePattern("(S0 \\ S1) <= S2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(R1 U R2) = R0"), FormulaPattern.parsePattern("(R0 \\ R1) <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S1 & S2)"), FormulaPattern.parsePattern("S0 <= S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R1 & R2)"), FormulaPattern.parsePattern("R0 <= R1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(S0 & S1) = S{}"), FormulaPattern.parsePattern("S0 <= (SUn \\ S1)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(R0 & R1) = R{}"), FormulaPattern.parsePattern("R0 <= (RUn \\ R1)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S1 \\ S2)"), FormulaPattern.parsePattern("S0 <= S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R1 \\ R2)"), FormulaPattern.parsePattern("R0 <= R1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S1 \\ S2)"), FormulaPattern.parsePattern("S0 <= (SUn \\ S2)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R1 \\ R2)"), FormulaPattern.parsePattern("R0 <= (RUn \\ R2)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S1 \\ S2)"), FormulaPattern.parsePattern("not S0 <= S2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R1 \\ R2)"), FormulaPattern.parsePattern("not R0 <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S1 \\ S2)"), FormulaPattern.parsePattern("S2 <= (SUn \\ S0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R1 \\ R2)"), FormulaPattern.parsePattern("R2 <= (RUn \\ R0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R1 <= R0"), FormulaPattern.parsePattern("(dom R1) <= (dom R0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R1 <= R0"), FormulaPattern.parsePattern("(ran R1) <= (ran R0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R2 <= ( R0 ; R1 )"), FormulaPattern.parsePattern("(dom R2) <= (dom R0)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R2 <= ( R0 ; R1 )"), FormulaPattern.parsePattern("(ran R2) <= (ran R1)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("( R0 + ) <= R1"), FormulaPattern.parsePattern("R0 <= R1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("(R1 $ R2) <= R0"), FormulaPattern.parsePattern("R2 <= R0")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 <: S1)"), FormulaPattern.parsePattern("R0 <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 <; S1)"), FormulaPattern.parsePattern("R0 <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 :> S1)"), FormulaPattern.parsePattern("R0 <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 ;> S1)"), FormulaPattern.parsePattern("R0 <= R2")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 <: S1)"), FormulaPattern.parsePattern("(dom R0) <= S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 <; S1)"), FormulaPattern.parsePattern("(dom R0) <= (SUn \\ S1)")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 :> S1)"), FormulaPattern.parsePattern("(ran R0) <= S1")));
            _closureRules.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R2 ;> S1)"), FormulaPattern.parsePattern("(ran R0) <= (SUn \\ S1)")));
            if (this.useMultiClosure()) {
                Vector<FormulaPattern> rules = new Vector<FormulaPattern>();
                rules.addElement(FormulaPattern.parsePattern("S1 = S2"));
                rules.addElement(FormulaPattern.parsePattern("S0 = S1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("S0 = S2")));
                rules = new Vector();
                rules.addElement(FormulaPattern.parsePattern("R1 = R2"));
                rules.addElement(FormulaPattern.parsePattern("R0 = R1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("R0 = R2")));
                rules = new Vector();
                rules.addElement(FormulaPattern.parsePattern("S1 <= S2"));
                rules.addElement(FormulaPattern.parsePattern("S0 <= S1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("S0 <= S2")));
                rules = new Vector();
                rules.addElement(FormulaPattern.parsePattern("R1 <= R2"));
                rules.addElement(FormulaPattern.parsePattern("R0 <= R1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("R0 <= R2")));
                rules = new Vector();
                rules.addElement(FormulaPattern.parsePattern("S1 <= S0"));
                rules.addElement(FormulaPattern.parsePattern("S0 <= S1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("S0 = S1")));
                rules = new Vector();
                rules.addElement(FormulaPattern.parsePattern("R1 <= R0"));
                rules.addElement(FormulaPattern.parsePattern("R0 <= R1"));
                _closureRules.addRule(new MultiRule(rules, FormulaPattern.parsePattern("R0 = R1")));
            }
        }
        return _closureRules;
    }

    public synchronized Simplifier getSimplifier() {
        if (_simplifier == null) {
            _simplifier = new Simplifier();
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= S0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= R0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 = S0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 = R0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("G0 = G0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("I0 = I0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S{} <= S0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R{} <= R0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= S{}"), FormulaPattern.parsePattern("S0 = S{}")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= R{}"), FormulaPattern.parsePattern("R0 = R{}")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("SUn <= S0"), FormulaPattern.parsePattern("S0 = SUn")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("RUn <= R0"), FormulaPattern.parsePattern("R0 = RUn")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= SUn"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= RUn"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= S0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= R0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 <= (S0 U S1)"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 <= (R0 U R1)"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("(S0 & S1) <= S0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("(R0 & R1) <= R0"), FormulaPattern.parsePattern("true")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("S0 < S0"), FormulaPattern.parsePattern("false")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("R0 < R0"), FormulaPattern.parsePattern("false")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("not S0 = S0"), FormulaPattern.parsePattern("false")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("not R0 = R0"), FormulaPattern.parsePattern("false")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("not G0 = G0"), FormulaPattern.parsePattern("false")));
            _simplifier.addRule(new SimpleRule(FormulaPattern.parsePattern("not I0 = I0"), FormulaPattern.parsePattern("false")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 \\ S{}"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 \\ R{}"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 \\ SUn"), TermPattern.parsePattern("S{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 \\ RUn"), TermPattern.parsePattern("R{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 \\ S0"), TermPattern.parsePattern("S{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 \\ R0"), TermPattern.parsePattern("R{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 U (S1 \\ S0)"), TermPattern.parsePattern("S0 U S1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 U (R1 \\ R0)"), TermPattern.parsePattern("R0 U R1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 U ((S1 \\ S0) U S2)"), TermPattern.parsePattern("S0 U (S1 U S2)")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 U ((R1 \\ R0) U R2)"), TermPattern.parsePattern("R0 U (R1 U R2)")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 & (S1 \\ S0)"), TermPattern.parsePattern("S{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 & (R1 \\ R0)"), TermPattern.parsePattern("R{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 & ((S1 \\ S0) & S2)"), TermPattern.parsePattern("S{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 & ((R1 \\ R0) & R2)"), TermPattern.parsePattern("R{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 \\ (S1 \\ S0)"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 \\ (R1 \\ R0)"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 \\ (S0 \\ S1)"), TermPattern.parsePattern("S0 & S1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 \\ (R0 \\ R1)"), TermPattern.parsePattern("R0 & R1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 U S0"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 U R0"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 U (S0 U S1)"), TermPattern.parsePattern("S0 U S1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 U (R0 U R1)"), TermPattern.parsePattern("R0 U R1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 & S0"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 & R0"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S0 & (S0 & S1)"), TermPattern.parsePattern("S0 & S1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R0 & (R0 & R1)"), TermPattern.parsePattern("R0 & R1")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("SUn U S0"), TermPattern.parsePattern("SUn0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("RUn U R0"), TermPattern.parsePattern("RUn0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("SUn & S0"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("RUn & R0"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S{} U S0"), TermPattern.parsePattern("S0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R{} U R0"), TermPattern.parsePattern("R0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("S{} & S0"), TermPattern.parsePattern("S{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("R{} & R0"), TermPattern.parsePattern("R{}0")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("dom R{}"), TermPattern.parsePattern("S{}")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("ran R{}"), TermPattern.parsePattern("S{}")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("dom RUn"), TermPattern.parsePattern("SUn")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("ran RUn"), TermPattern.parsePattern("SUn")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("dom RId"), TermPattern.parsePattern("SUn")));
            _simplifier.addTermSimplifier(new TermSimplifier(TermPattern.parsePattern("ran RId"), TermPattern.parsePattern("SUn")));
        }
        return _simplifier;
    }

    public void startSolver() {
        LadyBug.setStatus("Checking " + this.getSchemaName() + " " + this.getSchema().getName() + " ...");
        this.startSolver(false);
    }

    void startSolver(boolean useSameThread) {
        if (this.children.length == 0) {
            return;
        }
        this.currentChildNum = 1;
        this.currentChild = this.children[0];
        this.resetSolutions();
        this._solver = this.currentChild.getSolver();
        this.singleThreaded = useSameThread;
        if (!this.getUnlimitedTimeout() && this._timer != null) {
            this._timer.start();
        }
        this.timeStarted = new Date();
        this.currentChild.startSolver(useSameThread);
    }

    public void haltSolver() {
        if (this.currentChild == null) {
            return;
        }
        this.currentChild.haltSolver();
        LadyBug.setStatus("Halted checking " + this.getSchemaName() + " " + this.getSchema().getName());
    }

    public void resumeSolver() {
        if (this.currentChild == null) {
            return;
        }
        if (!this.getUnlimitedTimeout() && this._timer != null) {
            this._timer.start();
        }
        this.currentChild.resumeSolver();
    }

    protected boolean foundSolution(Assignment model) {
        boolean displayIt = false;
        SchemaSolver schemaSolver = this;
        synchronized (schemaSolver) {
            if (this.max_solutions_displayed < 0 || this.num_solutions < this.max_solutions_displayed) {
                this.solutions.insertElementAt(model, this.solutions.size());
                displayIt = true;
            }
            ++this.num_solutions;
        }
        if (displayIt) {
            this.displayModel(model);
        }
        SchemaSolver schemaSolver2 = this;
        synchronized (schemaSolver2) {
            if (this.max_solutions < 0 || this.num_solutions < this.max_solutions) {
                boolean bl = true;
                Object var5_6 = null;
                return bl;
            }
        }
        this.setStatus("Found " + String.valueOf(this.num_solutions) + " " + this.getModelName() + "s");
        LadyBug.message("Found " + String.valueOf(this.num_solutions) + " " + this.getModelName() + "s");
        this._solver.completionMessage();
        this.message("Required " + Formatter.formatElapsedTime(this.elapsedTime()) + " starting at " + Formatter.formatTime(this.solverStarted()));
        LadyBug.setStatus("Stopped checking " + this.getSchemaName() + " " + this.getSchema().getName());
        return false;
    }

    protected void finishedTranslation() {
        if (this.currentChildNum < this.children.length) {
            this.currentChild = this.children[this.currentChildNum];
            this._solver = this.currentChild.getSolver();
            ++this.currentChildNum;
            this.setStatus("Translating " + this.currentChild.getName());
            this.currentChild.startTranslator(this.singleThreaded);
        }
    }

    protected void finishedSolver() {
        if (this._timer != null) {
            this._timer.stop();
        }
        if (this.currentChildNum < this.children.length) {
            this.message("Completed checking " + this.currentChild.getName());
            this.message("Found " + Formatter.formatScalar(this.currentChild.numModels()) + " " + this.getModelName() + "s");
            this._solver.completionMessage();
            this.message("Required " + Formatter.formatElapsedTime(this.currentChild.elapsedTime()) + " starting at " + Formatter.formatTime(this.currentChild.solverStarted()));
            if (this.max_solutions < 0 || this.num_solutions < this.max_solutions) {
                this.currentChild = this.children[this.currentChildNum];
                this._solver = this.currentChild.getSolver();
                ++this.currentChildNum;
                this.setStatus("Checking " + this.currentChild.getName());
                this.currentChild.startSolver(this.singleThreaded);
                return;
            }
        } else if (this.children.length > 1) {
            this.message("Completed checking " + this.currentChild.getName());
            this.message("Found " + Formatter.formatScalar(this.currentChild.numModels()) + " " + this.getModelName() + "s");
            this._solver.completionMessage();
            this.message("Required " + Formatter.formatElapsedTime(this.currentChild.elapsedTime()) + " starting at " + Formatter.formatTime(this.currentChild.solverStarted()));
        }
        this.setStatus("Completed checking " + this.getSchema().getName());
        this.message("Completed checking " + this.getSchema().getName());
        this.message("Found " + Formatter.formatScalar(this.num_solutions) + " " + this.getModelName() + "s");
        if (this.children.length == 1) {
            this._solver.completionMessage();
        } else {
            this._solver.completionMessage(this.children);
        }
        this.message("Required " + Formatter.formatElapsedTime(this.elapsedTime()) + " starting at " + Formatter.formatTime(this.solverStarted()));
        LadyBug.setStatus("Completed checking " + this.getSchemaName() + " " + this.getSchema().getName());
        if (this._progressBar != null) {
            this._progressBar.progressorFinished();
        }
    }

    public String getModelName() {
        return this.getSchema().isClaim() ? "Counterexample" : (this.getSchema().isTransition() ? "Execution" : "Instance");
    }

    public String getModelConnector() {
        return this.getSchema().isClaim() ? "to" : "of";
    }

    public String getSchemaName() {
        return this.getSchema().isClaim() ? "Claim" : "Schema";
    }

    public void message(String msg) {
        LadyBug.message(this._console, msg);
    }

    private synchronized void resetSolutions() {
        this.solutions = new Vector();
        this.num_solutions = 0;
    }

    private void displayModel(Assignment model) {
        this.message("");
        this.message("Found " + this.getModelName() + " " + this.getModelConnector() + " " + this.getSchemaName() + " " + this.getSchema().getName() + ":");
        this.getAssignmentDisplay().display(this._console, model);
    }

    public void setStatus(String msg) {
        LadyBug.setStatus(this._statusConsole, msg);
    }

    Class findSolverClass(String _solverClass) {
        this.solverClasses();
        int i = 0;
        while (i < _solverClasses.length) {
            if (_solverClass.equals(_solverClassDescrs[i])) {
                return _solverClasses[i];
            }
            ++i;
        }
        return null;
    }

    private void createChildren() {
        this.getFormula();
        if (!this.useNormalize() || this._normalized.isSimple()) {
            this.children = new FormulaSolver[1];
            this.children[0] = new FormulaSolver(this, this.getSchema().getName(), this.getFormula());
        } else {
            if (this._normalized.isEmpty()) {
                this.currentChild = null;
                this.children = new FormulaSolver[0];
                this._solver = null;
                this.currentChildNum = 0;
                this.setStatus("Inconsistent requirements - cannot check");
                LadyBug.message(String.valueOf(this.getSchema().getName()) + " imposes inconsistent requirements");
                return;
            }
            Enumeration e = this._normalized.clauses();
            this.children = new FormulaSolver[this._normalized.numClauses()];
            int i = 0;
            while (e.hasMoreElements()) {
                Clause c = (Clause)e.nextElement();
                this.children[i] = new FormulaSolver(this, String.valueOf(this.getSchema().getName()) + " clause " + (i + 1), new NormalizedFormula(c));
                ++i;
            }
        }
        this.currentChild = this.children[0];
        this._solver = this.currentChild.getSolver();
        this.currentChildNum = 1;
    }

    static {
        _solverClassPossibles = new String[]{selEnumSolverClass};
        _solverClassNames = new String[]{selEnumSolverClassName};
        _solverClassDescrs = null;
        _solverClasses = null;
        orderClasses = new String[]{noOrderClass, sizeOrderClass};
        toggleOptions = new String[]{DerivedVarToggle, NormalizeToggle, ClosureToggle, MultiClosureToggle, OptimDerivedToggle};
    }

    private final class 1
    extends DoubleScalarInfoDescr {
        protected double getValue() {
            return SchemaSolver.this.totalCases();
        }

        /* synthetic */ 1(String $0, String $1) {
            super($0, $1);
        }
    }

    private final class 2
    extends ElapsedTimeInfoDescr {
        protected long getMillis() {
            return SchemaSolver.this.elapsedTime();
        }

        /* synthetic */ 2(String $0, String $1) {
            super($0, $1);
        }
    }

    private final class 3
    extends LongScalarInfoDescr {
        protected long getValue() {
            return SchemaSolver.this.numModelsFound();
        }

        /* synthetic */ 3(String $0, String $1) {
            super($0, $1);
        }
    }
}

