/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Hashtable;
import ladybug.engine.FactSet;
import ladybug.engine.LadyBug;
import ladybug.engine.QueryRulesEnum;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Rule;
import ladybug.engine.RuleEnumeration;
import ladybug.engine.SimpleRuleEnum;
import ladybug.engine.Simplifier;
import ladybug.parse.Formula;
import ladybug.parse.FormulaEnumeration;
import ladybug.parse.FormulaIndex;
import ladybug.parse.Term;
import ladybug.parse.Tree;

public class RuleSuite {
    private Hashtable findex;
    private Rule[] _rules = new Rule[20];
    private int currentAlloc = 20;
    private int currentMax = 0;
    private static final int allocSize = 20;
    private boolean debugRules;
    private String _name;
    private Simplifier _simple;

    public RuleSuite(String name, boolean debugIt, Simplifier s) {
        this.findex = new Hashtable();
        this.setDebugRules(debugIt);
        this._name = name;
        this._simple = s;
    }

    public void addRule(Rule r) {
        int i;
        if (this.currentMax == this.currentAlloc) {
            Rule[] old = this._rules;
            this.currentAlloc += 20;
            this._rules = new Rule[this.currentAlloc];
            i = 0;
            while (i < this.currentMax) {
                this._rules[i] = old[i];
                ++i;
            }
        }
        this._rules[this.currentMax++] = r;
        FormulaIndex[] fixes = r.indices();
        i = 0;
        while (i < fixes.length) {
            Rule[] ruls;
            Object k = fixes[i].primaryKey();
            if (this.findex.containsKey(k)) {
                ruls = (Rule[])this.findex.get(k);
            } else {
                ruls = new Rule[20];
                this.findex.put(k, ruls);
            }
            if (ruls[ruls.length - 1] != null) {
                Rule[] old = ruls;
                ruls = new Rule[old.length + 20];
                int j = 0;
                while (j < old.length) {
                    ruls[j] = old[j];
                    ++j;
                }
                ruls[old.length] = r;
                this.findex.put(k, ruls);
            } else if (ruls[0] == null) {
                ruls[0] = r;
            } else {
                int j = 1;
                while (j < ruls.length) {
                    if (ruls[j] == null) {
                        ruls[j] = r;
                        break;
                    }
                    ++j;
                }
            }
            ++i;
        }
    }

    public RuleEnumeration rules() {
        return new SimpleRuleEnum(this._rules, this.currentMax);
    }

    public RuleEnumeration rules(FormulaIndex fix) {
        return new QueryRulesEnum(this.findex, fix);
    }

    public String getName() {
        return this._name;
    }

    public String toString() {
        String s = "Rule Suite " + this.getName() + Tree.linesep();
        RuleEnumeration e = this.rules();
        while (e.hasMoreElements()) {
            Rule r = e.nextRule();
            s = String.valueOf(s) + "  " + r.toString() + Tree.linesep();
        }
        if (this._simple != null) {
            s = String.valueOf(s) + " Using simplifier" + Tree.linesep() + this._simple.toString();
        }
        return String.valueOf(s) + Tree.linesep();
    }

    public void setDebugRules(boolean debugIt) {
        this.debugRules = debugIt;
    }

    public void close(FactSet facts) {
        RuleEnumeration e = this.rules();
        while (e.hasMoreElements()) {
            Rule r = e.nextRule();
            if (this.debugRules) {
                LadyBug.logMessage("Checking rule " + r.toString());
            }
            FormulaIndex[] indices = r.indices();
            int i = 0;
            while (i < indices.length) {
                FormulaEnumeration ef = facts.facts(indices[i]);
                while (ef.hasMoreElements()) {
                    Formula f = ef.nextFormula();
                    if (this.debugRules) {
                        LadyBug.logMessage("  against formula " + f.toString());
                    }
                    ReplacementEnumeration en = r.enablers(f, facts);
                    while (en.hasMoreElements()) {
                        Term[] replacements = en.nextReplacement();
                        if (this.debugRules) {
                            LadyBug.logMessage("    matched with ");
                            int j = 0;
                            while (j < replacements.length) {
                                LadyBug.logMessage("        " + replacements[j].toString());
                                ++j;
                            }
                        }
                        r.fire(f, facts, replacements, this._simple);
                    }
                }
                ++i;
            }
        }
    }

    public void close(Formula f, FactSet facts) {
        RuleEnumeration e = this.rules(f.index());
        if (this.debugRules) {
            LadyBug.logMessage("Checking formula " + f.toString());
        }
        while (e.hasMoreElements()) {
            Rule r = e.nextRule();
            if (this.debugRules) {
                LadyBug.logMessage("  against rule " + r.toString());
            }
            ReplacementEnumeration en = r.enablers(f, facts);
            while (en.hasMoreElements()) {
                Term[] replacements = en.nextReplacement();
                if (this.debugRules) {
                    LadyBug.logMessage("    matched with ");
                    int i = 0;
                    while (i < replacements.length) {
                        LadyBug.logMessage("        " + replacements[i].toString());
                        ++i;
                    }
                }
                r.fire(f, facts, replacements, this._simple);
            }
        }
    }
}

