/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FunctionValue;
import ladybug.engine.RelationValue;
import ladybug.engine.ScalarValue;
import ladybug.engine.Scope;
import ladybug.engine.SetValue;
import ladybug.engine.Value;
import ladybug.engine.ValueError;
import ladybug.parse.RelationType;
import ladybug.parse.ScalarType;

public abstract class RelOrFuncValue
extends Value {
    protected int[] values;
    protected ScalarType domType;
    protected ScalarType ranType;
    protected int maxDomain;
    protected int maxRange;

    public RelOrFuncValue(RelationType ty, int domSize, int ranSize) {
        super(ty);
        this.domType = ty.domain();
        this.ranType = ty.range();
        this.values = new int[domSize];
        this.maxDomain = domSize;
        this.maxRange = ranSize;
        this.init();
    }

    public RelOrFuncValue(RelationType ty, Scope scope) {
        this(ty, (int)ty.domain().numValues(scope), (int)ty.range().numValues(scope));
    }

    public abstract boolean isMapped(int var1);

    public abstract boolean hasMapping(int var1, int var2);

    public final boolean hasMapping(ScalarValue from, ScalarValue to) {
        return this.hasMapping(from.getAdjValue(), to.getAdjValue());
    }

    public abstract void addMapping(int var1, int var2);

    public final void addMapping(ScalarValue from, ScalarValue to) {
        this.addMapping(from.getAdjValue(), to.getAdjValue());
    }

    public abstract void removeMapping(int var1, int var2);

    public final void removeMapping(ScalarValue from, ScalarValue to) {
        this.removeMapping(from.getAdjValue(), to.getAdjValue());
    }

    public abstract void card(ScalarValue var1);

    public abstract int card();

    public abstract void compose(RelOrFuncValue var1, RelOrFuncValue var2);

    public abstract void closure(RelationValue var1);

    public abstract void override(RelOrFuncValue var1, RelOrFuncValue var2);

    public abstract void union(RelOrFuncValue var1, RelationValue var2);

    public abstract void intersect(RelOrFuncValue var1, RelOrFuncValue var2);

    public abstract void diff(RelOrFuncValue var1, RelOrFuncValue var2);

    public abstract void domRestr(SetValue var1, RelOrFuncValue var2);

    public abstract void negDomRestr(SetValue var1, RelOrFuncValue var2);

    public abstract void ranRestr(SetValue var1, RelOrFuncValue var2);

    public abstract void negRanRestr(SetValue var1, RelOrFuncValue var2);

    public abstract void domain(SetValue var1);

    public abstract void range(SetValue var1);

    public abstract void transpose(RelationValue var1);

    public abstract void transpose(FunctionValue var1) throws ValueError;

    public abstract void image(SetValue var1, SetValue var2);

    public abstract void apply(ScalarValue var1, ScalarValue var2) throws ValueError;

    public abstract void head(ScalarValue var1) throws ValueError;

    public abstract int head() throws ValueError;

    public abstract void tail(ScalarValue var1) throws ValueError;

    public abstract int tail() throws ValueError;

    public abstract boolean isFunction();

    public abstract boolean isInjection();

    public abstract boolean isTotal();

    public abstract boolean isOnto();

    public abstract boolean isChain();

    public abstract boolean equals(RelOrFuncValue var1);

    public abstract boolean contains(RelOrFuncValue var1);

    public abstract boolean containsPlus(RelOrFuncValue var1);

    public void reflClosure(RelationValue answer) {
        this.closure(answer);
        int i = 0;
        while (i < this.maxDomain) {
            answer.addMapping(i, i);
            ++i;
        }
    }

    public abstract void init();

    public abstract int mapping(int var1);

    public abstract void setMapping(int var1, int var2) throws ValueError;

    public int domainMax() {
        return this.maxDomain;
    }

    public int rangeMax() {
        return this.maxRange;
    }

    public ScalarType domainType() {
        return this.domType;
    }

    public ScalarType rangeType() {
        return this.ranType;
    }
}

