/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.MapletMatcher;
import ladybug.engine.NoMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Simplifier;
import ladybug.engine.TermPattern;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Maplet;
import ladybug.parse.RelDisplay;
import ladybug.parse.SourceLoc;
import ladybug.parse.Term;
import ladybug.parse.TermIndex;
import ladybug.parse.TypeConflict;

public final class RelDisplayPattern
extends TermPattern {
    private TermPattern _from;
    private TermPattern _to;

    public RelDisplayPattern(TermPattern from, TermPattern to) {
        this._from = from;
        this._to = to;
    }

    public ReplacementEnumeration matches(Term t) {
        if (!t.getType().isRelation()) {
            return new NoMatcher();
        }
        if (!(t instanceof RelDisplay)) {
            return new NoMatcher();
        }
        RelDisplay rd = (RelDisplay)t;
        return new MapletMatcher(this._from, this._to, rd.maplets());
    }

    public Term instantiate(Term[] replacements, Simplifier s) {
        RelDisplay rd = new RelDisplay();
        try {
            rd.addMaplet(new Maplet(this._from.instantiate(replacements, s), this._to.instantiate(replacements, s)));
            rd.updateLocation(SourceLoc.noLoc);
        }
        catch (TypeConflict tc) {
            ErrorReporter.internalError(SourceLoc.noLoc, tc);
        }
        return rd;
    }

    public int getTypeClass() {
        return 1;
    }

    public TermIndex index() {
        return TermIndex.createRelDispIndex(1);
    }

    public int numReplacements() {
        int tr;
        int fr = this._from.numReplacements();
        if (fr > (tr = this._to.numReplacements())) {
            return fr;
        }
        return tr;
    }

    public String toString() {
        return "{ " + this._from.toString() + "->" + this._to.toString() + " }";
    }
}

