/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Vector;
import ladybug.engine.FactSet;
import ladybug.engine.FormulaPattern;
import ladybug.engine.MultiMatcher;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.Rule;
import ladybug.engine.Simplifier;
import ladybug.parse.Formula;
import ladybug.parse.FormulaIndex;
import ladybug.parse.FormulaList;
import ladybug.parse.Term;

public class MultiRule
extends Rule {
    private Vector _enablers;
    private FormulaPattern _action;
    private FormulaList _matchingFormulae;
    private FormulaIndex[] _indices;

    public MultiRule(Vector enablers, FormulaPattern action) {
        this._enablers = (Vector)enablers.clone();
        this._action = action;
        this._matchingFormulae = null;
        this._indices = new FormulaIndex[enablers.size()];
        int i = 0;
        while (i < enablers.size()) {
            this._indices[i] = ((FormulaPattern)enablers.elementAt(i)).index();
            ++i;
        }
    }

    public ReplacementEnumeration enablers(Formula f, FactSet facts) {
        this._matchingFormulae = new FormulaList();
        return new MultiMatcher(this._enablers, f, facts, this._matchingFormulae);
    }

    public Formula instantiate(Term[] replacements, Simplifier s) {
        if (this._action != null) {
            Formula inst = this._action.instantiate(replacements, s);
            if (s != null) {
                return s.simplifyFormula(inst);
            }
            return inst;
        }
        return null;
    }

    public void fire(Formula f, FactSet facts, Term[] replacements, Simplifier s) {
        if (this._action != null) {
            Formula inst = this.instantiate(replacements, s);
            facts.addFact(inst);
            facts.markImpliedBy(inst, this._matchingFormulae);
        }
    }

    public FormulaIndex[] indices() {
        return this._indices;
    }

    public String toString() {
        String s = "{";
        Enumeration e = this._enablers.elements();
        boolean first = true;
        while (e.hasMoreElements()) {
            FormulaPattern _enabler = (FormulaPattern)e.nextElement();
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + ",";
            }
            s = String.valueOf(s) + " " + _enabler.toString();
        }
        s = String.valueOf(s) + " } -> ";
        if (this._action != null) {
            s = String.valueOf(s) + this._action.toString();
        }
        return s;
    }
}

