/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.NoSuchElementException;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.TermPattern;
import ladybug.parse.Term;
import ladybug.parse.TermEnumeration;

final class ListMatcher
implements ReplacementEnumeration {
    private boolean hasMore;
    private ReplacementEnumeration matcher;
    private Term[] replacements;
    private Term elem;
    private TermPattern _match;
    private TermEnumeration _terms;

    ListMatcher(TermPattern match, TermEnumeration terms) {
        this._match = match;
        this._terms = terms;
        this.elem = null;
        this.checkMore();
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextReplacement();
    }

    public Term[] nextReplacement() throws NoSuchElementException {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        Term[] repl = this.replacements;
        this.checkMore();
        return repl;
    }

    private void checkMore() {
        while (true) {
            if (this.elem == null) {
                if (!this._terms.hasMoreElements()) {
                    this.hasMore = false;
                    return;
                }
                this.elem = this._terms.nextTerm();
                this.matcher = this._match.matches(this.elem);
            }
            if (this.matcher.hasMoreElements()) {
                this.replacements = this.matcher.nextReplacement();
                this.hasMore = true;
                return;
            }
            this.elem = null;
        }
    }
}

