/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.io.File;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import ladybug.engine.LadyBugInfo;
import ladybug.engine.SchemaSolver;
import ladybug.engine.Scope;
import ladybug.engine.Script;
import ladybug.parse.GivenType;
import ladybug.parse.Schema;
import ladybug.parse.Specification;
import ladybug.util.Console;
import ladybug.util.Formatter;
import ladybug.util.SimpleConsole;

public class LadyBug {
    private static Hashtable threadInfo;
    private static Hashtable scrThreads;
    private static LadyBugInfo defInfo;
    private static Console _console;
    private static String _fileSep;

    public static void main(String[] args) {
        LadyBug.init();
        defInfo.main(args);
    }

    public static void init() {
        _console = new SimpleConsole();
        threadInfo = new Hashtable();
        scrThreads = new Hashtable();
        defInfo = new LadyBugInfo(null);
    }

    public static void setConsole(Console console) {
        _console = console;
    }

    public static Console getConsole() {
        return _console;
    }

    public static boolean load(File f) {
        LadyBugInfo info = LadyBug.getInfo();
        return info.load(f);
    }

    public static SchemaSolver findSolver(Schema s) {
        return LadyBug.findSolver(s, _console);
    }

    public static SchemaSolver findSolver(Schema s, Console c) {
        LadyBugInfo info = LadyBug.getInfo();
        return info.findSolver(s, c == null ? _console : c);
    }

    public static SchemaSolver findSolver(String name, Console c) {
        Schema s = LadyBug.findSchema(name);
        if (s == null) {
            return null;
        }
        return LadyBug.findSolver(s, c);
    }

    public static Schema findSchema(String name) {
        Specification spec = LadyBug.getSpec();
        if (spec == null) {
            return null;
        }
        Enumeration e = spec.schemas();
        Schema s = null;
        while (e.hasMoreElements()) {
            s = (Schema)e.nextElement();
            if (!s.getName().equals(name)) continue;
            return s;
        }
        return null;
    }

    public static void solverFinished(SchemaSolver ss) {
        LadyBugInfo info = LadyBug.getInfo();
        info.solverFinished(ss);
    }

    public static Specification getSpec() {
        LadyBugInfo info = LadyBug.getInfo();
        return info.getSpec();
    }

    public static Scope getScope() {
        LadyBugInfo info = LadyBug.getInfo();
        return info.getScope();
    }

    public static void scopeChanged(GivenType gt) {
        LadyBugInfo info = LadyBug.getInfo();
        info.scopeChanged(gt);
    }

    public static File getFile() {
        LadyBugInfo info = LadyBug.getInfo();
        return info.getFile();
    }

    public static void runScript(Script scr) {
        Thread scrThread = new Thread(scr);
        LadyBugInfo info = new LadyBugInfo(scr);
        threadInfo.put(scrThread, info);
        scrThreads.put(scr, scrThread);
        LadyBug.setStatus("Running script " + scr.getFile().getName());
        scrThread.start();
    }

    public static void stopScript(Script scr) {
        if (!scrThreads.containsKey(scr)) {
            return;
        }
        Thread scrThread = (Thread)scrThreads.get(scr);
        scrThread.stop();
        LadyBug.scriptFinished(scr);
    }

    public static void stopScripts() {
        Enumeration e = scrThreads.keys();
        while (e.hasMoreElements()) {
            Script scr = (Script)e.nextElement();
            LadyBug.stopScript(scr);
        }
    }

    public static void pauseScript(Script scr) {
        if (!scrThreads.containsKey(scr)) {
            return;
        }
        Thread scrThread = (Thread)scrThreads.get(scr);
        scrThread.suspend();
    }

    public static void pauseScripts() {
        Enumeration e = scrThreads.keys();
        while (e.hasMoreElements()) {
            Script scr = (Script)e.nextElement();
            LadyBug.pauseScript(scr);
        }
    }

    public static void resumeScript(Script scr) {
        if (!scrThreads.containsKey(scr)) {
            return;
        }
        Thread scrThread = (Thread)scrThreads.get(scr);
        scrThread.resume();
    }

    public static void resumeScripts() {
        Enumeration e = scrThreads.keys();
        while (e.hasMoreElements()) {
            Script scr = (Script)e.nextElement();
            LadyBug.resumeScript(scr);
        }
    }

    public static void scriptMessages() {
        Enumeration e = scrThreads.keys();
        while (e.hasMoreElements()) {
            Script scr = (Script)e.nextElement();
            LadyBugInfo info = LadyBug.getInfo(scr);
            _console.appendTextLine("");
            _console.appendTextLine("Script " + scr.getName());
            _console.appendTextLine(info.getMessages());
            _console.appendTextLine("Status: " + info.getStatus());
            _console.appendTextLine("");
        }
    }

    public static boolean startLogging(File logfile) {
        if (logfile.exists() && !logfile.isFile()) {
            LadyBug.consoleMessage(String.valueOf(logfile.getPath()) + " is not a file");
            return false;
        }
        if (logfile.exists() && !logfile.canWrite()) {
            LadyBug.consoleMessage("File " + logfile.getPath() + " is not writable");
            return false;
        }
        LadyBugInfo info = LadyBug.getInfo();
        return info.startLogging(logfile);
    }

    public static void pauseLogging() {
        LadyBugInfo info = LadyBug.getInfo();
        info.pauseLogging();
    }

    public static void resumeLogging() {
        LadyBugInfo info = LadyBug.getInfo();
        info.resumeLogging();
    }

    public static void finishLogging() {
        LadyBugInfo info = LadyBug.getInfo();
        info.resumeLogging();
    }

    public static void setStatus(String msg) {
        LadyBug.setStatus(_console, msg);
    }

    public static void setStatus(Console console, String msg) {
        LadyBugInfo info = LadyBug.getInfo();
        if (info.getScript() != null) {
            info.setStatus(msg);
            if (info.isLogging()) {
                info.getLogFile().println(String.valueOf(Formatter.formatTime(new Date())) + " : " + msg);
                info.getLogFile().flush();
            }
            return;
        }
        console.setStatus(msg);
    }

    public static void message(String msg) {
        LadyBug.message(_console, msg);
    }

    static void message(Console console, String msg) {
        LadyBugInfo info = LadyBug.getInfo();
        if (info.getScript() != null) {
            info.addMessage(msg);
            if (info.isLogging()) {
                info.getLogFile().println(msg);
                info.getLogFile().flush();
            } else {
                console.appendTextLine("Script " + info.getScript().getName() + ": " + msg);
            }
            return;
        }
        if (info.isLogging()) {
            info.getLogFile().println(msg);
            info.getLogFile().flush();
        }
        console.appendTextLine(msg);
    }

    public static void logMessage(String msg) {
        LadyBug.logMessage(_console, msg);
    }

    public static void logMessage(Console console, String msg) {
        LadyBugInfo info = LadyBug.getInfo();
        if (info.getScript() != null) {
            if (info.isLogging()) {
                info.getLogFile().println(msg);
                info.getLogFile().flush();
            }
            return;
        }
        if (info.isLogging()) {
            info.getLogFile().println(msg);
            info.getLogFile().flush();
        } else {
            console.appendTextLine(msg);
        }
    }

    public static void consoleMessage(String msg) {
        LadyBug.consoleMessage(_console, msg);
    }

    public static void consoleMessage(Console console, String msg) {
        LadyBugInfo info = LadyBug.getInfo();
        if (info.getScript() != null) {
            info.addMessage(msg);
            if (info.isLogging()) {
                info.getLogFile().println(msg);
                info.getLogFile().flush();
            }
            console.appendTextLine("Script " + info.getScript().getName() + ": " + msg);
            return;
        }
        console.appendTextLine(msg);
    }

    public static void parserError(String msg) {
        String m = "Error: " + msg;
        LadyBugInfo info = LadyBug.getInfo();
        info.addError();
        LadyBug.consoleMessage(m);
    }

    public static void parserWarning(String msg) {
        String m = "Warning: " + msg;
        LadyBugInfo info = LadyBug.getInfo();
        if (info.getScript() != null) {
            LadyBug.logMessage(m);
        } else {
            LadyBug.consoleMessage(m);
        }
    }

    static void scriptFinished(Script scr) {
        LadyBug.consoleMessage("Script " + scr.getName() + " finshed");
        LadyBugInfo info = LadyBug.getInfo(scr);
        info.finishLogging();
        Thread scrThread = (Thread)scrThreads.get(scr);
        scrThreads.remove(scr);
        threadInfo.remove(scrThread);
    }

    private static LadyBugInfo getInfo() {
        Thread thr = Thread.currentThread();
        if (threadInfo.containsKey(thr)) {
            return (LadyBugInfo)threadInfo.get(thr);
        }
        return defInfo;
    }

    private static LadyBugInfo getInfo(Script scr) {
        if (!scrThreads.containsKey(scr)) {
            return null;
        }
        Thread thr = (Thread)scrThreads.get(scr);
        if (threadInfo.containsKey(thr)) {
            return (LadyBugInfo)threadInfo.get(thr);
        }
        return null;
    }

    public static String localizeFile(File theFile) {
        return LadyBug.localizeFile(theFile.getName());
    }

    public static String localizeFile(String theFile) {
        String newName = "";
        int index = theFile.indexOf(37);
        int lastIndex = 0;
        while (index >= 0) {
            if (lastIndex < index) {
                String pred = theFile.substring(lastIndex, index);
                newName = String.valueOf(newName) + pred;
            }
            if (theFile.charAt(index + 1) == '%') {
                newName = String.valueOf(newName) + "%";
                lastIndex = index + 2;
            } else {
                byte[] buffer = new byte[1];
                String hex = theFile.substring(index + 1, index + 3);
                buffer[0] = (byte)Integer.parseInt(hex, 16);
                newName = String.valueOf(newName) + new String(buffer);
                lastIndex = index + 3;
            }
            if (lastIndex >= theFile.length()) break;
            index = theFile.indexOf(37, lastIndex);
        }
        if (lastIndex < theFile.length()) {
            newName = String.valueOf(newName) + theFile.substring(lastIndex);
        }
        return newName;
    }

    public static String localizePath(File theFile) {
        return LadyBug.localizePath(theFile.getPath());
    }

    public static String localizePath(String thePath) {
        String fs = LadyBug.fileSep();
        return LadyBug.localizeFile(thePath);
    }

    private static synchronized String fileSep() {
        if (_fileSep == null) {
            _fileSep = System.getProperty("file.separator");
        }
        return _fileSep;
    }
}

