/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Date;
import ladybug.engine.Assignment;
import ladybug.engine.DerivedVars;
import ladybug.engine.EnumVars;
import ladybug.engine.FactSet;
import ladybug.engine.LadyBug;
import ladybug.engine.OptionSet;
import ladybug.engine.SchemaSolver;
import ladybug.engine.SizeVarOrder;
import ladybug.engine.SolverController;
import ladybug.engine.SolverNotReady;
import ladybug.engine.VarOrder;
import ladybug.parse.Formula;
import ladybug.parse.GivenType;
import ladybug.parse.Schema;
import ladybug.parse.Tree;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;
import ladybug.util.Formatter;
import ladybug.util.ProgressorObserver;

public class FormulaSolver {
    private SolverController _solver;
    private VarOrder _order;
    private SchemaSolver _parent;
    private String _name;
    private VariableList _vars;
    private OptionSet changes;
    private EnumVars _enums;
    private DerivedVars _derived;
    private FactSet _facts;
    private Formula _formula;
    private Date timeEnded;
    private Date timeStarted;
    private long priorTime;
    private boolean translatorRunning;
    private boolean translatorStarted;
    private boolean translated;
    private boolean solverRunning;
    private boolean solverStarted;
    private boolean singleThreaded;
    private boolean chainSolver;
    private double _totalCases = 0.0;
    private long _numModels;
    private ProgressorObserver _progressBar;
    private boolean _debugFacts;
    private boolean _debugConsClose;
    private boolean _debugDerived;

    public FormulaSolver(SchemaSolver parent, String name, Formula f) {
        this._parent = parent;
        this._formula = f;
        this._vars = f.vars(parent.getSchema());
        this._name = name;
        this._solver = null;
        this._totalCases = 0.0;
        this._numModels = 0L;
        this.translatorRunning = false;
        this.translatorStarted = false;
        this.translated = false;
        this.solverRunning = false;
        this.solverStarted = false;
        this.timeStarted = null;
        this.changes = new OptionSet();
        this.createSolver();
    }

    public SchemaSolver getParent() {
        return this._parent;
    }

    public Schema getSchema() {
        return this._parent.getSchema();
    }

    public Formula getFormula() {
        return this._formula;
    }

    public String getName() {
        return this._name;
    }

    public VarEnumeration getVars() {
        return this._vars.elements();
    }

    public SolverController getSolver() {
        return this._solver;
    }

    public void setProgressorObserver(ProgressorObserver pbar) {
        this._progressBar = pbar;
        if (this._solver != null) {
            this._solver.setProgressorObserver(pbar);
        }
    }

    public void scopeChanged(GivenType gt) {
        this.changes.addOption(256);
        this._totalCases = 0.0;
    }

    public synchronized void setVarOrder(VarOrder ordering) {
        this._order = ordering;
        if (this._order != null && this._enums != null) {
            this._enums.reorder(this._order);
            this.changes.addOption(2048);
        }
    }

    public synchronized void setOrderClass(String oclass) {
        this.changes.addOption(8192);
    }

    public double totalCases() {
        if (this._totalCases == 0.0) {
            double tc = 1.0;
            VarEnumeration ve = this._vars.elements();
            while (ve.hasMoreElements()) {
                Variable v = ve.nextVar();
                if (v.getType() == null) continue;
                tc *= (double)v.getType().numValues(this._parent.getScope());
            }
            this._totalCases = tc;
        }
        return this._totalCases;
    }

    public long elapsedTime() {
        if (this.translated) {
            if (this.solverRunning) {
                return new Date().getTime() - this.timeStarted.getTime() + this.priorTime;
            }
            return this.timeEnded.getTime() - this.timeStarted.getTime() + this.priorTime;
        }
        if (this.translatorRunning) {
            return new Date().getTime() - this.timeStarted.getTime() + this.priorTime;
        }
        return 0L;
    }

    public long numModels() {
        return this._numModels;
    }

    public void setUseDerivedVars(boolean useIt) {
        this.changes.addOption(512);
        this.checkChanges();
    }

    public void setOptimDerivedVars(boolean doIt) {
        if (this._derived != null) {
            if (doIt) {
                this._derived.optimize();
            } else {
                this._derived = null;
            }
            this.changes.addOption(512);
            this.checkChanges();
        }
    }

    public void setUseNormalize(boolean useIt) {
        this.changes.addOption(16);
        this.checkChanges();
    }

    public void setUseConsClosure(boolean useIt) {
        this.changes.addOption(32);
        this.changes.addOption(4096);
        this._facts = null;
        this.checkChanges();
    }

    public void setDebugDerived(boolean debugIt) {
        this._debugDerived = debugIt;
        if (this._derived != null) {
            this._derived.setDebugDerived(debugIt);
        }
    }

    void setDebugFacts(boolean debugIt) {
        this._debugFacts = debugIt;
        if (debugIt) {
            this._facts = null;
        }
    }

    public Date solverStarted() {
        return this.timeStarted;
    }

    public synchronized EnumVars getEnumVars() {
        if (this._enums == null) {
            this._enums = new EnumVars(this);
            this.setVarOrder(this.createOrder());
        }
        return this._enums;
    }

    public synchronized DerivedVars getDerivedVars() {
        if (!this._parent.useDerivedVars()) {
            return null;
        }
        if (this._derived == null) {
            this._derived = new DerivedVars(this.getFacts(), this._parent.optimDerivedVars(), this._debugDerived, this._parent.getScope());
        }
        return this._derived;
    }

    public String dumpDerived() {
        DerivedVars derived = this.getDerivedVars();
        if (derived == null) {
            return "Derived Variables are disabled" + Tree.linesep() + Tree.linesep();
        }
        String s = "Derived Variables for " + this._name + Tree.linesep() + Tree.linesep();
        EnumVars enums = this.getEnumVars();
        VarEnumeration e = derived.derivedVars();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            s = String.valueOf(s) + v.toString() + "\t\t: " + v.getType().toString() + " (" + String.valueOf(enums.findPosition(v)) + ")" + Tree.linesep();
            s = String.valueOf(s) + "  = " + derived.findEquiv(v).toString() + Tree.linesep();
        }
        return s;
    }

    public FactSet getFacts() {
        if (this._facts != null) {
            return this._facts;
        }
        return this.getFacts(null);
    }

    private synchronized FactSet getFacts(ProgressorObserver pbar) {
        if (this._facts == null) {
            this._parent.setStatus("Computing facts for " + this.getName() + " ...");
            this._facts = new FactSet(this, this._parent.getClosureRules(), this._debugFacts, pbar);
        }
        return this._facts;
    }

    synchronized void startSolver(boolean useSameThread) {
        if (this.translatorRunning || this.solverRunning) {
            return;
        }
        if (this.translatorStarted) {
            this.finishTranslator();
        } else if (this.solverStarted) {
            this.finishSolver();
        }
        this.checkChanges();
        this.singleThreaded = useSameThread;
        try {
            if (!this.translated) {
                this.startTranslator(false);
                if (!this.singleThreaded) {
                    return;
                }
            }
            if (this.getFacts().containsFalse()) {
                this.timeStarted = this.timeEnded;
                this._parent.finishedSolver();
                return;
            }
            this._numModels = 0L;
            this.solverStarted = true;
            this.solverRunning = true;
            this._parent.setStatus("Checking " + this.getName() + " ...");
            this.priorTime = 0L;
            this.timeStarted = new Date();
            this._solver.startSolver(useSameThread);
        }
        catch (SolverNotReady solverNotReady) {
            LadyBug.message("startSolver: Solver not ready");
            this.translated = false;
        }
    }

    public synchronized void haltSolver() {
        block7: {
            if (this.singleThreaded) {
                return;
            }
            this.timeEnded = new Date();
            try {
                if (this.translatorRunning) {
                    this._solver.haltTranslator();
                    this._parent.setStatus("Stopped translating " + this._name);
                    this.translatorRunning = false;
                } else if (this.solverRunning) {
                    this._solver.haltSolver();
                    this._parent.setStatus("Stopped checking " + this._name);
                    this._solver.completionMessage();
                    this.solverRunning = false;
                }
            }
            catch (SolverNotReady solverNotReady) {
                LadyBug.message("haltSolver: Solver not ready");
                if (this.translatorRunning) {
                    this.translatorRunning = false;
                }
                if (!this.solverRunning) break block7;
                this.solverRunning = false;
            }
        }
    }

    public synchronized void resumeSolver() {
        block8: {
            if (this.singleThreaded) {
                return;
            }
            if (this.translatorRunning || this.solverRunning) {
                return;
            }
            try {
                if (this.translatorStarted) {
                    this.translatorRunning = true;
                    this._parent.setStatus("Translating " + this.getName() + " ...");
                    this.priorTime += this.timeEnded.getTime() - this.timeStarted.getTime();
                    this.timeStarted = new Date();
                    this._solver.resumeTranslator();
                } else if (this.solverStarted) {
                    this.solverRunning = true;
                    this._parent.setStatus("Checking " + this.getName() + " ...");
                    this.priorTime += this.timeEnded.getTime() - this.timeStarted.getTime();
                    this.timeStarted = new Date();
                    this._solver.resumeSolver();
                }
            }
            catch (SolverNotReady solverNotReady) {
                LadyBug.message("resumeSolver: Solver not ready");
                if (this.translatorStarted) {
                    this.translatorStarted = false;
                    this.translatorRunning = false;
                }
                if (!this.solverRunning) break block8;
                this.solverStarted = false;
                this.solverRunning = false;
            }
        }
    }

    synchronized void startTranslator(boolean translateOnly) {
        this.chainSolver = translateOnly ^ true;
        this.priorTime = 0L;
        this._numModels = 0L;
        this.timeStarted = new Date();
        FactSet facts = this.getFacts(this._progressBar);
        if (facts.containsFalse()) {
            this._parent.message("The inconsistent requirements for " + this.getName() + " cannot be satisfied.");
            this.finishedTranslation(false);
            return;
        }
        if (facts.size() == 0) {
            this._parent.message(String.valueOf(this.getName()) + " is unconstrained.");
            this.finishedTranslation(false);
            return;
        }
        this._parent.setStatus("Translating " + this.getName() + " ...");
        try {
            this.translatorStarted = true;
            this.translatorRunning = true;
            this._solver.startTranslator(this.singleThreaded);
        }
        catch (SolverNotReady solverNotReady) {
            this._parent.message("Translator not ready");
            this.translatorStarted = false;
            this.translatorRunning = false;
        }
    }

    protected synchronized void finishedTranslation(boolean fullMessages) {
        this.translatorRunning = false;
        this.translatorStarted = false;
        this.translated = true;
        this.timeEnded = new Date();
        if (fullMessages) {
            this._parent.message("Completed translation of " + this._name);
            this._solver.transCompletionMessage();
        }
        this._parent.message("Required " + Formatter.formatElapsedTime(this.elapsedTime()) + " starting at " + Formatter.formatTime(this.solverStarted()));
        if (this.chainSolver) {
            if (!this.singleThreaded) {
                this.startSolver(false);
            }
        } else if (!this.singleThreaded) {
            this._parent.finishedTranslation();
        }
    }

    protected boolean foundSolution(Assignment model) {
        this.timeEnded = new Date();
        ++this._numModels;
        if (this._parent.foundSolution(model)) {
            return true;
        }
        if (this.singleThreaded) {
            return false;
        }
        this.solverRunning = false;
        try {
            this._solver.haltSolver();
        }
        catch (SolverNotReady solverNotReady) {}
        return true;
    }

    protected synchronized void finishedSolver() {
        this.solverRunning = false;
        this.solverStarted = false;
        this.timeEnded = new Date();
        this._parent.finishedSolver();
    }

    private synchronized void finishTranslator() {
        if (this._solver != null) {
            try {
                this._solver.finishTranslator();
            }
            catch (SolverNotReady solverNotReady) {}
        }
        this.translatorRunning = false;
        this.translatorStarted = false;
    }

    private synchronized void finishSolver() {
        if (this._solver != null) {
            try {
                this._solver.finishSolver();
            }
            catch (SolverNotReady solverNotReady) {}
        }
        this.solverRunning = false;
        this.solverStarted = false;
    }

    private synchronized void checkChanges() {
        if (this._facts != null && !this._facts.stillValid(this.changes)) {
            this._facts = null;
            this.changes.addOption(4096);
        }
        if (this._parent.useDerivedVars()) {
            if (this._derived != null && !this._derived.stillValid(this.changes)) {
                if (this._derived.numDerived() > 0) {
                    VarEnumeration ve = this._derived.derivedVars();
                    while (ve.hasMoreElements()) {
                        this._derived.makeUnderived(ve.nextVar());
                    }
                    this.changes.addOption(4096);
                    this.changes.addOption(512);
                }
                this._derived = null;
            }
        } else if (this._derived != null) {
            if (this._derived.numDerived() > 0) {
                VarEnumeration ve = this._derived.derivedVars();
                while (ve.hasMoreElements()) {
                    this._derived.makeUnderived(ve.nextVar());
                }
                this.changes.addOption(4096);
                this.changes.addOption(512);
            }
            this._derived = null;
        }
        if (this._enums != null && !this._enums.stillValid(this.changes)) {
            this._enums = null;
            this._order = null;
            this.changes.addOption(1024);
        }
        if (this._solver != null && !this._solver.stillValid(this.changes)) {
            if (this.solverStarted) {
                this.finishSolver();
            }
            if (this.translatorStarted) {
                this.finishTranslator();
            }
            this._solver = null;
            this.translated = false;
            this._solver.untranslate();
        }
        if (this.translated && !this._solver.translationValid(this.changes)) {
            this.translated = false;
            this._solver.untranslate();
        }
        this.changes.clear();
    }

    private synchronized void createSolver() {
        this.checkChanges();
        this._solver = null;
        Class solverClass = this._parent.findSolverClass(this._parent.currentSolverClass());
        if (solverClass == null) {
            return;
        }
        try {
            this._solver = (SolverController)solverClass.newInstance();
            this._solver.setController(this);
            this._solver.setProgressorObserver(this._progressBar);
        }
        catch (InstantiationException instantiationException) {
            this._solver = null;
        }
        catch (IllegalAccessException illegalAccessException) {
            this._solver = null;
        }
        this.translatorRunning = false;
        this.translated = false;
        this.translatorStarted = false;
        this.solverStarted = false;
        this.solverRunning = false;
    }

    private VarOrder createOrder() {
        VarOrder order = null;
        if (this._solver != null) {
            order = this._solver.orderVars(this._parent.currentOrderClass(), this.getEnumVars(), this._parent.getScope());
        }
        if (order != null) {
            return order;
        }
        if (this._parent.currentOrderClass().equals(SchemaSolver.sizeOrderClass)) {
            order = new SizeVarOrder(this.getEnumVars().variables(), this._parent.getScope(), this.getEnumVars());
        }
        return order;
    }
}

