/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.DerivedVars;
import ladybug.engine.FormulaSolver;
import ladybug.engine.OptionSet;
import ladybug.engine.Scope;
import ladybug.engine.VarOrder;
import ladybug.parse.ErrorReporter;
import ladybug.parse.Formula;
import ladybug.parse.SimpleVarEnum;
import ladybug.parse.SourceLoc;
import ladybug.parse.Tree;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;
import ladybug.parse.VariableList;

public class EnumVars {
    private Variable[] vars = new Variable[20];
    private int _numVars = 0;
    private int _allocVars = 20;
    private static final int allocSize = 20;
    private FormulaSolver controller;
    private OptionSet dependencies;

    public EnumVars(FormulaSolver fs) {
        this.controller = fs;
        this.dependencies = new OptionSet();
        this.findVars();
    }

    public VariableList variables() {
        VariableList vl = new VariableList();
        int i = 0;
        while (i < this._numVars) {
            vl.addVar(this.vars[i]);
            ++i;
        }
        return vl;
    }

    public VarEnumeration elements() {
        return new SimpleVarEnum(this.vars, this._numVars);
    }

    public void reorder(VarOrder ordering) {
        int size = this._numVars;
        boolean first = true;
        Variable[] old = this.vars;
        this.vars = new Variable[this._numVars];
        int ix = 0;
        while (ix < this._numVars) {
            int i;
            Variable v = old[ix];
            if (first) {
                i = 0;
                while (i < size) {
                    this.vars[i] = v;
                    ++i;
                }
                first = false;
            } else {
                i = ordering.indexOf(v);
                this.vars[i] = v;
            }
            ++ix;
        }
    }

    public boolean isEnumerated(Variable var) {
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public int numVars() {
        return this._numVars;
    }

    public int findPosition(Variable var) {
        int i = 0;
        while (i < this._numVars) {
            if (this.vars[i] == var) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Variable findVar(int i) {
        return this.vars[i];
    }

    public void makeDependOn(int option) {
        this.dependencies.addOption(option);
    }

    public boolean stillValid(OptionSet changes) {
        return this.dependencies.intersect(changes).isEmpty();
    }

    public double numValues(Scope scope) {
        double nv = 1.0;
        int i = 0;
        while (i < this._numVars) {
            nv *= (double)this.vars[i].getType().numValues(scope);
            ++i;
        }
        return nv;
    }

    public String toString() {
        String s = "";
        int i = 0;
        while (i < this._numVars) {
            Variable v = this.vars[i];
            s = String.valueOf(s) + String.valueOf(i + 1) + ": " + v.getName() + " : " + v.getType().toString() + Tree.linesep();
            ++i;
        }
        return s;
    }

    private void findVars() {
        DerivedVars dv = this.controller.getDerivedVars();
        Formula f = this.controller.getFormula();
        VariableList vl = f.vars(this.controller.getSchema());
        VarEnumeration e = vl.elements();
        while (e.hasMoreElements()) {
            Variable v = e.nextVar();
            if (v.getSchema() != this.controller.getParent().getSchema()) {
                ErrorReporter.internalError(SourceLoc.noLoc, "Inconsistent schema ownership of variable " + v.getName());
            }
            if (dv != null && dv.isDerived(v)) continue;
            if (this._numVars >= this._allocVars) {
                this._allocVars += 20;
                Variable[] old = this.vars;
                this.vars = new Variable[this._allocVars];
                int i = 0;
                while (i < this._numVars) {
                    this.vars[i] = old[i];
                    ++i;
                }
            }
            this.vars[this._numVars] = v;
            ++this._numVars;
        }
        this.dependencies.addOption(512);
    }
}

