/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import ladybug.engine.FormulaSolver;
import ladybug.engine.LadyBug;
import ladybug.engine.SolverController;

public abstract class DumpOption {
    public static final String dumpSpec = "Display Specification";
    public static final String dumpClauses = "Display Clauses";
    public static final String dumpSchema = "Display Schema";
    public static final String dumpTrans = "Display Translation";
    public static final String dumpEnums = "Display Enum Vars";
    public static final String dumpDerived = "Display Derived Vars";
    public static final String dumpScope = "Display Scope";
    public static final String dumpFacts = "Display Facts";
    protected SolverController _solver;
    protected FormulaSolver controller;
    private String[] basicCommands = new String[]{"Display Scope", "Display Clauses", "Display Enum Vars", "Display Derived Vars", "Display Translation"};

    public boolean dumpValue(boolean checkParent, String command) {
        if (command.equals(dumpSpec)) {
            LadyBug.message(LadyBug.getSpec().toString());
            return true;
        }
        if (command.equals(dumpClauses)) {
            LadyBug.message(this.controller.getParent().dumpClauses());
            return true;
        }
        if (command.equals(dumpSchema)) {
            LadyBug.message(this.controller.getSchema().toString());
            return true;
        }
        if (command.equals(dumpTrans)) {
            LadyBug.message(this._solver.dumpTranslation());
            return true;
        }
        if (command.equals(dumpEnums)) {
            LadyBug.message(this._solver.dumpEnums());
            return true;
        }
        if (command.equals(dumpDerived)) {
            LadyBug.message(this.controller.dumpDerived());
            return true;
        }
        if (command.equals(dumpScope)) {
            LadyBug.message(this.controller.getParent().getScope().toString());
            return true;
        }
        if (command.equals(dumpFacts)) {
            LadyBug.message(this.controller.getFacts().toString());
            return true;
        }
        return false;
    }

    public abstract String[] allDumpCommands();

    public String[] basicDumpCommands() {
        return this.basicCommands;
    }

    protected DumpOption(SolverController solver) {
        this._solver = solver;
        this.controller = this._solver.getFormulaSolver();
    }
}

