/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Hashtable;
import ladybug.engine.BadPeerClass;
import ladybug.engine.TermPeer;
import ladybug.parse.BinaryOperator;
import ladybug.parse.BinaryTerm;

public abstract class BinaryTermPeer
extends TermPeer {
    public TermPeer left;
    public TermPeer right;
    public BinaryOperator op;

    public BinaryTermPeer() throws BadPeerClass {
        this((BinaryTerm)TermPeer.peerSource, TermPeer.peerTypes);
    }

    public BinaryTermPeer(BinaryTerm source, Hashtable peerTypes) throws BadPeerClass {
        super(source);
        this.left = source.left.createPeer(peerTypes);
        this.right = source.right.createPeer(peerTypes);
        this.op = source.op;
    }

    public String toString() {
        String l = this.left.getSource().precedence() > this.op.precedence() ? "(" + this.left.toString() + ")" : this.left.getSource().toString();
        String r = this.right.getSource().precedence() > this.op.precedence() ? "(" + this.right.toString() + ")" : this.right.toString();
        if (this.op.useSpaces()) {
            return String.valueOf(l) + " " + this.op.toString() + " " + r;
        }
        return String.valueOf(l) + this.op.toString() + r;
    }
}

