/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.NoSuchElementException;
import ladybug.engine.ReplacementEnumeration;
import ladybug.engine.TermPattern;
import ladybug.parse.Term;

final class BinaryMatcher
implements ReplacementEnumeration {
    private boolean hasMore;
    private boolean commuted;
    private Term[] replacements;
    private Term[] lrepl;
    private ReplacementEnumeration leftMatcher;
    private ReplacementEnumeration rightMatcher;
    private TermPattern _left;
    private TermPattern _right;
    private Term l;
    private Term r;
    private Term rhs;
    private int min;
    private int max;

    BinaryMatcher(TermPattern lp, Term lt, TermPattern rp, Term rt, boolean canCommute) {
        this.commuted = canCommute ^ true;
        this.l = lt;
        this.rhs = this.r = rt;
        this._left = lp;
        this._right = rp;
        this.leftMatcher = this._left.matches(this.l);
        this.lrepl = null;
        this.rightMatcher = this._right.matches(this.r);
        int lr = this._left.numReplacements();
        int rr = this._right.numReplacements();
        if (lr > rr) {
            this.min = rr;
            this.max = lr;
        } else {
            this.min = lr;
            this.max = rr;
        }
        this.checkMore();
    }

    public boolean hasMoreElements() {
        return this.hasMore;
    }

    public Object nextElement() throws NoSuchElementException {
        return this.nextReplacement();
    }

    public Term[] nextReplacement() throws NoSuchElementException {
        if (!this.hasMore) {
            throw new NoSuchElementException();
        }
        Term[] elem = this.replacements;
        this.checkMore();
        return elem;
    }

    private void checkMore() {
        while (true) {
            if (this.lrepl == null) {
                if (!this.leftMatcher.hasMoreElements()) {
                    if (this.commuted) break;
                    this.commuted = true;
                    this.leftMatcher = this._left.matches(this.r);
                    this.rhs = this.l;
                    continue;
                }
                this.lrepl = this.leftMatcher.nextReplacement();
                this.rightMatcher = this._right.matches(this.rhs);
            }
            block1: while (this.rightMatcher.hasMoreElements()) {
                Term[] rrepl = this.rightMatcher.nextReplacement();
                int i = 0;
                while (i < this.min) {
                    if (this.lrepl[i] != null && rrepl[i] != null && !this.lrepl[i].equiv(rrepl[i])) continue block1;
                    ++i;
                }
                this.replacements = new Term[this.max];
                i = 0;
                while (i < this.lrepl.length) {
                    if (this.lrepl[i] != null) {
                        this.replacements[i] = this.lrepl[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < rrepl.length) {
                    if (rrepl[i] != null) {
                        this.replacements[i] = rrepl[i];
                    }
                    ++i;
                }
                this.hasMore = true;
                return;
            }
            this.lrepl = null;
        }
        this.hasMore = false;
    }
}

