/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import ladybug.engine.BadPeerClass;
import ladybug.engine.TermPeer;
import ladybug.parse.AssocTerm;
import ladybug.parse.BinaryOperator;
import ladybug.parse.TermEnumeration;

public abstract class AssocTermPeer
extends TermPeer {
    public BinaryOperator op;
    private Vector _operands;

    public AssocTermPeer() throws BadPeerClass {
        this((AssocTerm)TermPeer.peerSource, TermPeer.peerTypes);
    }

    public AssocTermPeer(AssocTerm source, Hashtable peerTypes) throws BadPeerClass {
        super(source);
        this.op = source.op;
        this._operands = new Vector();
        TermEnumeration e = source.operands();
        while (e.hasMoreElements()) {
            this._operands.addElement(e.nextTerm().createPeer(peerTypes));
        }
    }

    public Enumeration operands() {
        return this._operands.elements();
    }

    public String toString() {
        String s = "";
        boolean first = true;
        String os = this.op.useSpaces() ? " " + this.op.toString() + " " : this.op.toString();
        Enumeration e = this.operands();
        while (e.hasMoreElements()) {
            TermPeer t = (TermPeer)e.nextElement();
            if (first) {
                first = false;
            } else {
                s = String.valueOf(s) + os;
            }
            s = t.precedence() > this.op.precedence() ? String.valueOf(s) + "(" + t.toString() + ")" : String.valueOf(s) + t.toString();
        }
        return s;
    }
}

