/*
 * Decompiled with CFR 0.152.
 */
package ladybug.engine;

import java.util.Hashtable;
import ladybug.engine.Value;
import ladybug.parse.Schema;
import ladybug.parse.VarEnumeration;
import ladybug.parse.Variable;

public class Assignment {
    private Schema _schema;
    private Hashtable values;
    private int num_vars;
    private static String linesep;

    public Assignment(Schema schema) {
        if (linesep == null && (linesep = System.getProperty("line.separator")) == null) {
            linesep = "\n";
        }
        this._schema = schema;
        VarEnumeration e = schema.vars();
        int i = 0;
        while (e.hasMoreElements()) {
            e.nextElement();
            ++i;
        }
        this.num_vars = i;
        this.values = new Hashtable();
    }

    public int numVars() {
        return this.num_vars;
    }

    public Value getValue(Variable var) {
        if (this.values.containsKey(var)) {
            return (Value)this.values.get(var);
        }
        return null;
    }

    public void setValue(Variable var, Value val) {
        this.values.put(var, val);
    }

    public String toString() {
        String s = "";
        VarEnumeration e = this._schema.vars();
        while (e.hasMoreElements()) {
            Variable var = e.nextVar();
            if (var.isSilent()) continue;
            Value val = this.getValue(var);
            s = String.valueOf(s) + var.getName() + " = ";
            s = val == null ? String.valueOf(s) + "<null>" + linesep : String.valueOf(s) + val.toString() + linesep;
        }
        return s;
    }
}

