/*
 * Decompiled with CFR 0.152.
 */
package fontanus.util;

import java.awt.AWTEventMulticaster;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;

public class Timer
implements Runnable {
    private Thread _theThread;
    private ActionListener _listener;
    private String _command;
    private int _delay;

    public Timer(int n) {
        this(n, null);
    }

    public Timer(int n, String string) {
        this.setDelay(n);
        this.setActionCommand(string);
    }

    public int getDelay() {
        return this._delay;
    }

    public void setDelay(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Delay must be >= 0");
        }
        this._delay = n;
    }

    public String getActionCommand() {
        return this._command;
    }

    public void setActionCommand(String string) {
        this._command = string;
    }

    public synchronized void addActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.add(this._listener, actionListener);
        this.notify();
    }

    public void removeActionListener(ActionListener actionListener) {
        this._listener = AWTEventMulticaster.remove(this._listener, actionListener);
    }

    private synchronized void fireActionEvent() {
        if (this._listener != null) {
            this._listener.actionPerformed(new ActionEvent(this, 1001, this._command));
            return;
        }
        try {
            this.wait();
            return;
        }
        catch (InterruptedException interruptedException) {
            return;
        }
    }

    public synchronized void start() {
        if (this._theThread == null) {
            this._theThread = new Thread(this);
            this._theThread.start();
        }
    }

    public void stop() {
        this._theThread = null;
    }

    public void run() {
        Thread thread = Thread.currentThread();
        while (thread == this._theThread) {
            try {
                Thread.sleep(this._delay);
            }
            catch (InterruptedException interruptedException) {}
            this.fireActionEvent();
        }
    }
}

