/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.window;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Insets;
import java.awt.MenuComponent;
import java.awt.MenuContainer;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;

public class WindowUtil {
    private static int _cascadeX = 0;
    private static int _cascadeY = 0;

    public static void close(Window w) {
        ((Component)w).setVisible(false);
        w.dispose();
    }

    public static void center(Window w) {
        Frame f = WindowUtil.getFrame(w.getParent());
        if (f == null) {
            WindowUtil.center(w, new Rectangle(Toolkit.getDefaultToolkit().getScreenSize()));
        } else {
            WindowUtil.center(w, f.getBounds());
        }
    }

    private static void center(Window w, Rectangle where) {
        Dimension size = w.getSize();
        int x = (where.width - size.width) / 2 + where.x;
        int y = (where.height - size.height) / 2 + where.y;
        WindowUtil.setLocation(w, x, y);
    }

    public static synchronized void cascade(Window w) {
        Point where = WindowUtil.getLocation(w, _cascadeX, _cascadeY);
        if (where.x != _cascadeX || where.y != _cascadeY) {
            _cascadeX = 0;
            _cascadeY = 0;
        }
        ((Component)w).setLocation(_cascadeX, _cascadeY);
        Insets i = w.getInsets();
        int increment = Math.max(i.left, i.top) + 1;
        _cascadeX += increment;
        _cascadeY += increment;
    }

    public static Frame getFrame(Component c) {
        while (c != null && !(c instanceof Frame)) {
            c = c.getParent();
        }
        return (Frame)c;
    }

    public static Frame getFrame(MenuComponent c) {
        MenuContainer parent = null;
        if (c != null) {
            parent = c.getParent();
        }
        while (parent != null && parent instanceof MenuComponent) {
            parent = ((MenuComponent)((Object)parent)).getParent();
        }
        if (parent instanceof Frame) {
            return (Frame)parent;
        }
        return null;
    }

    public static Window getWindow(Component c) {
        while (c != null && !(c instanceof Window)) {
            c = c.getParent();
        }
        return (Window)c;
    }

    private static void setLocation(Component c, int x, int y) {
        Point where = WindowUtil.getLocation(c, x, y);
        c.setLocation(where);
    }

    private static Point getLocation(Component c, int x, int y) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension size = c.getSize();
        return new Point(WindowUtil.bind(x, size.width, 0, screen.width), WindowUtil.bind(y, size.height, 0, screen.height));
    }

    private static int bind(int value, int size, int min, int max) {
        value = Math.min(value, max - size);
        value = Math.max(value, min);
        return value;
    }
}

