/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.window;

import fontanus.ui.window.DialogFactory;
import fontanus.ui.window.WindowUtil;
import fontanus.util.SavableObject;
import java.awt.Component;
import java.awt.MenuComponent;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;

public class WindowCloser
extends WindowAdapter
implements ActionListener {
    private String _title;
    private String _message;
    private boolean _autoExit;
    private SavableObject _saver;
    private static WindowCloser _defaultCloser;
    private static WindowCloser _defaultAutoExitCloser;

    protected WindowCloser(String title, String message, SavableObject saver, boolean autoExit) {
        if (title == null && message != null || title != null && message == null) {
            throw new IllegalArgumentException("Title and message must either both be null or both be non-null");
        }
        this._title = title;
        this._message = message;
        this._saver = saver;
        this._autoExit = autoExit;
    }

    public static WindowCloser getInstance() {
        return WindowCloser.getInstance(false);
    }

    public static WindowCloser getInstance(String title, String message) {
        return new WindowCloser(title, message, null, false);
    }

    public static WindowCloser getInstance(String title, String message, boolean autoExit) {
        return new WindowCloser(title, message, null, autoExit);
    }

    public static WindowCloser getInstance(String title, String message, SavableObject saver, boolean autoExit) {
        return new WindowCloser(title, message, saver, autoExit);
    }

    public static WindowCloser getInstance(String title, SavableObject saver, boolean autoExit) {
        return new WindowCloser(title, null, saver, autoExit);
    }

    public static WindowCloser getInstance(boolean autoExit) {
        if (autoExit) {
            if (_defaultAutoExitCloser == null) {
                _defaultAutoExitCloser = new WindowCloser(null, null, null, true);
            }
            return _defaultAutoExitCloser;
        }
        if (_defaultCloser == null) {
            _defaultCloser = new WindowCloser(null, null, null, false);
        }
        return _defaultCloser;
    }

    public String getMessage() {
        return this._message;
    }

    public SavableObject getSavable() {
        return this._saver;
    }

    public boolean getAutoExit() {
        return this._autoExit;
    }

    public void windowClosing(WindowEvent evt) {
        this.close(evt.getWindow());
    }

    public void windowClosed(WindowEvent evt) {
        block2: {
            if (!this._autoExit) break block2;
            try {
                System.exit(0);
            }
            catch (SecurityException securityException) {
                Thread.currentThread().stop();
            }
        }
    }

    public void actionPerformed(ActionEvent evt) {
        Object source = evt.getSource();
        if (source instanceof Component) {
            this.close(WindowUtil.getWindow((Component)source));
        } else if (source instanceof MenuComponent) {
            this.close(WindowUtil.getFrame((MenuComponent)source));
        } else {
            throw new IllegalArgumentException("WindowCloser should only be registered to listen for ActionEvents from Components and MenuComponents.");
        }
    }

    public void close(Window w) {
        String result;
        if (this._saver != null) {
            if (this._message == null) {
                this._saver.save();
            } else if (this._saver.needsSave()) {
                String result2 = DialogFactory.showYesNoCancelDialog(w, this._title, this._message);
                if (result2.equals("cancel")) {
                    return;
                }
                if (result2.equals("yes") && !this._saver.save()) {
                    return;
                }
            }
        } else if (this._message != null && !(result = DialogFactory.showYesCancelDialog(w, this._title, this._message)).equals("yes")) {
            return;
        }
        WindowUtil.close(w);
    }
}

