/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.window;

import fontanus.ui.window.DialogConstants;
import fontanus.ui.window.StandardDialog;
import fontanus.ui.window.WindowUtil;
import java.awt.Component;
import java.awt.FileDialog;
import java.io.File;

public class DialogFactory
implements DialogConstants {
    public static void showOkDialog(Component parent, String title, String message) {
        DialogFactory.showDialog(parent, title, message, DialogConstants.OK_ARRAY, true);
    }

    public static String showOkCancelDialog(Component parent, String title, String message) {
        return DialogFactory.showDialog(parent, title, message, DialogConstants.OK_CANCEL, true);
    }

    public static String showYesNoDialog(Component parent, String title, String message) {
        return DialogFactory.showDialog(parent, title, message, DialogConstants.YES_NO, false);
    }

    public static String showYesCancelDialog(Component parent, String title, String message) {
        return DialogFactory.showDialog(parent, title, message, DialogConstants.YES_CANCEL, true);
    }

    public static String showYesNoCancelDialog(Component parent, String title, String message) {
        return DialogFactory.showDialog(parent, title, message, DialogConstants.YES_NO_CANCEL, true);
    }

    private static String showDialog(Component parent, String title, String message, String[] actions2, boolean cancelOption) {
        if (cancelOption) {
            return StandardDialog.showStandardDialog(new StandardDialog(parent, title, message, StandardDialog.localize(actions2), actions2));
        }
        return StandardDialog.showStandardDialog(new StandardDialog(parent, title, message, StandardDialog.localize(actions2), actions2, -1));
    }

    public static File showLoadDialog(Component parent, String title) {
        FileDialog fd = new FileDialog(WindowUtil.getFrame(parent), title);
        fd.show();
        String fname = fd.getFile();
        if (fname != null) {
            return new File(fd.getDirectory(), fname);
        }
        return null;
    }

    public static File showSaveDialog(Component parent, String title) {
        FileDialog fd = new FileDialog(WindowUtil.getFrame(parent), title, 1);
        fd.show();
        String fname = fd.getFile();
        if (fname != null) {
            return new File(fd.getDirectory(), fname);
        }
        return null;
    }
}

