/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.layout;

import fontanus.ui.layout.TableHeadingList;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Hashtable;

public class TableLayout
implements LayoutManager,
Serializable {
    private TableHeadingList _rows;
    private TableHeadingList _cols;
    private Hashtable _components = new Hashtable();

    public TableLayout() {
        this._cols = new TableHeadingList(true);
        this._rows = new TableHeadingList(false);
    }

    public TableLayout(int[] colbases, int[] colweights, int[] rowbases, int[] rowweights) {
        this._cols = new TableHeadingList(true, colbases, colweights);
        this._rows = new TableHeadingList(false, rowbases, rowweights);
    }

    public void addRow(int base, int weight) {
        this._rows.addHeading(base, weight);
    }

    public void removeLastRow() {
        this._rows.removeLastHeading();
    }

    public void removeAllRows() {
        this._rows.removeAllHeadings();
    }

    public int getRowCount() {
        return this._rows.getHeadingCount();
    }

    public void addCol(int base, int weight) {
        this._cols.addHeading(base, weight);
    }

    public void removeLastCol() {
        this._cols.removeLastHeading();
    }

    public void removeAllCols() {
        this._cols.removeAllHeadings();
    }

    public void setComponentPosition(Component c, int x, int y) {
        this.setComponentPosition(c, x, y, 1, 1, true);
    }

    public void setComponentPosition(Component c, int x, int y, int width, int height) {
        this.setComponentPosition(c, x, y, width, height, true);
    }

    public void setComponentPosition(Component c, int x, int y, int width, int height, boolean usePreferredSize) {
        this.removeLayoutComponent(c);
        this._components.put(c, new Rectangle(x, y, width, height));
        if (usePreferredSize) {
            this._cols.getHeading(x).addComponent(c, width);
            this._rows.getHeading(y).addComponent(c, height);
        }
    }

    public void addComponent(Component c, Container cont, int x, int y) {
        this.addComponent(c, cont, x, y, 1, 1, true);
    }

    public void addComponent(Component c, Container cont, int x, int y, int width, int height) {
        this.addComponent(c, cont, x, y, width, height, true);
    }

    public void addComponent(Component c, Container cont, int x, int y, int width, int height, boolean usePreferredSize) {
        this.setComponentPosition(c, x, y, width, height, usePreferredSize);
        cont.add(c);
    }

    public void addLayoutComponent(String name, Component comp) {
    }

    public void layoutContainer(Container parent) {
        Dimension size = parent.size();
        Component[] comps = parent.getComponents();
        Insets in = parent.insets();
        int[] rowpos = this._rows.getPositions(size.height - (in.top + in.bottom));
        int[] colpos = this._cols.getPositions(size.width - (in.left + in.right));
        int i = 0;
        while (i < comps.length) {
            Component theComponent = comps[i];
            if (theComponent.isVisible()) {
                Rectangle r = (Rectangle)this._components.get(theComponent);
                if (r == null) {
                    r = new Rectangle(0, 0, 0, 0);
                } else if (r.x >= colpos.length || r.y >= rowpos.length) {
                    r.reshape(0, 0, 0, 0);
                }
                int x = colpos[r.x] + in.left;
                int y = rowpos[r.y] + in.top;
                int width = colpos[r.x + r.width] - colpos[r.x];
                int height = rowpos[r.y + r.height] - rowpos[r.y];
                theComponent.reshape(x, y, width, height);
            }
            ++i;
        }
    }

    public Dimension minimumLayoutSize(Container parent) {
        Insets i = parent.insets();
        int width = this._cols.getMinimumSize() + i.left + i.right;
        int height = this._rows.getMinimumSize() + i.top + i.bottom;
        return new Dimension(width, height);
    }

    public Dimension preferredLayoutSize(Container parent) {
        Insets i = parent.insets();
        int width = this._cols.getPreferredSize() + i.left + i.right;
        int height = this._rows.getPreferredSize() + i.top + i.bottom;
        return new Dimension(width, height);
    }

    public void removeLayoutComponent(Component comp) {
        Rectangle oldPosition = (Rectangle)this._components.remove(comp);
        if (oldPosition != null) {
            this._cols.getHeading(oldPosition.x).removeComponent(comp);
            this._rows.getHeading(oldPosition.y).removeComponent(comp);
        }
    }
}

