/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui.layout;

import java.awt.Component;
import java.io.Serializable;
import java.util.Vector;

class TableHeading
implements Serializable {
    private int _base;
    private int _weight;
    private int _size;
    private Vector _components;
    private Vector _spans;

    public TableHeading() {
        this(0, 0);
    }

    public TableHeading(int base, int weight) {
        this.setBase(base);
        this.setWeight(weight);
    }

    public int getBase() {
        return this._base;
    }

    public void setBase(int base) {
        if (base < 0) {
            throw new IllegalArgumentException("Base must be >= 0");
        }
        this._base = base;
    }

    public int getWeight() {
        return this._weight;
    }

    public void setWeight(int weight) {
        if (weight < 0) {
            throw new IllegalArgumentException("Weight must be >= 0");
        }
        this._weight = weight;
    }

    synchronized void addComponent(Component c, int span) {
        if (c == null) {
            return;
        }
        if (span < 1) {
            throw new IllegalArgumentException("span must be >= 1");
        }
        if (this._components == null) {
            this._components = new Vector();
            this._spans = new Vector();
        }
        int count = this._components.size();
        int i = 0;
        while (i < count) {
            if (span < (Integer)this._spans.elementAt(i)) {
                this._components.insertElementAt(c, i);
                this._spans.insertElementAt(new Integer(span), i);
                return;
            }
            ++i;
        }
        this._components.addElement(c);
        this._spans.addElement(new Integer(span));
    }

    synchronized boolean removeComponent(Component c) {
        if (this._components == null) {
            return false;
        }
        int index = this._components.indexOf(c);
        if (index >= 0) {
            this._components.removeElementAt(index);
            this._spans.removeElementAt(index);
            return true;
        }
        return false;
    }

    Vector getComponents() {
        return this._components;
    }

    Vector getSpans() {
        return this._spans;
    }

    void resetSize() {
        this._size = this._base;
    }

    void ensureSize(int size) {
        this._size = Math.max(this._size, size);
    }

    void incrementSize(int increment) {
        this._size += increment;
    }

    int getSize() {
        return this._size;
    }
}

