/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui;

import fontanus.ui.BufferedPanel;
import java.awt.Dimension;
import java.awt.Graphics;

public class ProgressBar
extends BufferedPanel {
    private int _min;
    private int _max;
    private int _value;

    public ProgressBar() {
        this(0, 100, 0);
    }

    public ProgressBar(int min, int max) {
        this(min, max, min);
    }

    public ProgressBar(int min, int max, int value) {
        this.setValues(min, max, value);
    }

    public int getMin() {
        return this._min;
    }

    public void setMin(int min) {
        this.setValues(min, this._max, this._value);
    }

    public int getMax() {
        return this._max;
    }

    public void setMax(int max) {
        this.setValues(this._min, max, this._value);
    }

    public int getValue() {
        return this._value;
    }

    public void setValue(int value) {
        this.setValues(this._min, this._max, value);
    }

    public void setValues(int min, int max, int value) {
        if (min >= max) {
            throw new IllegalArgumentException("min must be < max");
        }
        if (value < min || value > max) {
            throw new IllegalArgumentException("value must be between min and max");
        }
        this._min = min;
        this._max = max;
        this._value = value;
        this.repaint();
    }

    public void paintBuffer(Graphics g) {
        super.paintBuffer(g);
        Dimension d = this.size();
        float factor = (float)(this._value - this._min) / (float)(this._max - this._min);
        if (d.width >= d.height) {
            g.fillRect(0, 0, (int)((float)d.width * factor), d.height);
        } else {
            int h = (int)((float)d.height * factor);
            g.fillRect(0, d.height - h, d.width, h);
        }
    }
}

