/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Panel;
import java.awt.Rectangle;

public class BufferedPanel
extends Panel {
    private Image _offscreenImg;
    private boolean _clearBackground = true;

    public void reshape(int x, int y, int width, int height) {
        Dimension d = this.size();
        if (d.width != width || d.height != height) {
            this._offscreenImg = null;
        }
        super.reshape(x, y, width, height);
    }

    public void update(Graphics g) {
        this.paint(g);
    }

    public void paint(Graphics g) {
        Dimension d = this.size();
        Rectangle clip = g.getClipRect();
        if (this._offscreenImg == null) {
            if (d.width < 1 || d.height < 1) {
                return;
            }
            this._offscreenImg = this.createImage(d.width, d.height);
        }
        Graphics offscreenG = this._offscreenImg.getGraphics();
        if (this._clearBackground) {
            offscreenG.setColor(this.getBackground());
            offscreenG.fillRect(0, 0, d.width, d.height);
        }
        offscreenG.setColor(this.getForeground());
        offscreenG.setFont(this.getFont());
        offscreenG.clipRect(clip.x, clip.y, clip.width, clip.height);
        super.paint(offscreenG);
        this.paintBuffer(offscreenG);
        g.drawImage(this._offscreenImg, 0, 0, this);
        offscreenG.dispose();
    }

    public void paintBuffer(Graphics g) {
    }

    public void setClearBackground(boolean clear) {
        this._clearBackground = clear;
    }

    public boolean doesClearBackground() {
        return this._clearBackground;
    }
}

