/*
 * Decompiled with CFR 0.152.
 */
package fontanus.ui;

import fontanus.ui.BufferedPanel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;

public class BorderPanel
extends BufferedPanel {
    private static final int HEIGHT = 0;
    private static final int ASCENT = 1;
    private static final int WIDTH = 2;
    private static final int DEFAULT_PADDING = 0;
    private int _padding;
    private String _label;

    public BorderPanel() {
        this(null, 0);
    }

    public BorderPanel(String string) {
        this(string, 0);
    }

    public BorderPanel(String string, int n) {
        this.setLabel(string);
        this.setPadding(n);
    }

    public int getPadding() {
        return this._padding;
    }

    public synchronized void setPadding(int n) {
        if (n < 0) {
            throw new IllegalArgumentException("Padding must be >= 0");
        }
        this._padding = n;
        this.invalidate();
    }

    public String getLabel() {
        return this._label;
    }

    public synchronized void setLabel(String string) {
        this._label = string;
        this.repaint();
    }

    public synchronized void paintBuffer(Graphics graphics) {
        super.paintBuffer(graphics);
        Dimension dimension = this.size();
        int[] nArray = this.calcLabelSizes();
        int n = nArray[0] / 2;
        Rectangle rectangle = new Rectangle(0, n, dimension.width - 1, dimension.height - 1 - n);
        graphics.drawRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (this._label != null && !this._label.equals("")) {
            int n2 = nArray[1];
            int n3 = this._padding * 2;
            graphics.setColor(this.getBackground());
            graphics.drawLine(n3 - 1, n, n3 + nArray[2] + 1, n);
            graphics.setColor(this.getForeground());
            graphics.drawString(this._label, n3, n2);
        }
    }

    public Insets insets() {
        Insets insets = super.insets();
        int n = this._padding + 1;
        return new Insets(insets.top + n + this.calcLabelHeight(), insets.left + n, insets.bottom + n, insets.right + n);
    }

    private synchronized int calcLabelHeight() {
        if (this._label == null || this._label.equals("")) {
            return 0;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return fontMetrics.getMaxAscent() + fontMetrics.getMaxDescent();
    }

    private synchronized int[] calcLabelSizes() {
        int[] nArray = new int[3];
        if (this._label == null || this._label.equals("")) {
            return nArray;
        }
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n = fontMetrics.getMaxAscent();
        nArray[0] = n + fontMetrics.getMaxDescent();
        nArray[1] = n;
        nArray[2] = fontMetrics.stringWidth(this._label);
        return nArray;
    }

    public static BorderPanel decorateComponent(Component component) {
        BorderPanel borderPanel = new BorderPanel();
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add("Center", component);
        return borderPanel;
    }
}

