/*
 * Mach Operating System
 * Copyright (c) 1993 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	exit.c,v $
 * Revision 2.2  93/08/11  14:32:24  mrt
 * 	Created.
 * 	[93/08/06            bershad]
 * 
 *
 * File:	exit.c
 * Author:	Brian Bershad
 * Date:	July 1993
 *
 * Provide post execution callback into profiling routines. Really
 * need atexit from ansi libc, but there is no ansi libc.
 *
 *
 */
/*
 * Simplified version of atexit and exit.
 *
 * Is not equivalent to ansi atexit since we
 *	- are called after cleanup
 *	- only call one function
 * This is only here for gprof support. Note that tahoe is not ansi
 * compatible, so you shouldn't even expect this function to exist.
 * Only here to deal with brain damaged i386 distribution.
 */

void (*exitfn)() = 0;

int
atexit(fn)
    void (*fn)();
{
    exitfn = fn;
    return 0;
}
    

void
_exit(code)
    int code;
{
    if (exitfn) {
	(*exitfn)();
    }
    _exit2(code);
}


