/*
 * Copyright (c) 1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 *
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS "AS IS"
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 *
 * Carnegie Mellon requests users of this software to return to
 *
 *  Software Distribution Coordinator  or  Software_Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 *
 * any improvements or extensions that they make and grant Carnegie Mellon
 * the rights to redistribute these changes.
 */
/*
 *  HISTORY
 *  $Log:	mkmajorvers.c,v $
 * Revision 2.2  92/11/13  17:17:03  mrt
 * 	Copied here from Mach 2.5 libsys.a
 * 
 * 
 * Revision 2.3  92/11/09  16:38:05  mrt
 * 	Save and restore any existing signal handler.
 * 	[92/11/06            mrt]
 * 
 * Revision 2.2  92/07/23  14:01:25  mrt
 * 	Used to tell if we are running Mach 2.5 or Mach 3.0
 * 	[92/07/23  13:34:02  mrt]
 * 
 */

#include <sys/types.h>
#include <sys/signal.h>

int
mk_major_version()
{
#if defined(ibmrt) || defined (multimax)
	/* will never run Mach 3.0 */
	return (2);
#else
	int ret;
	int (*savsig)();

	savsig = signal(SIGSYS, SIG_IGN);
	ret  = mach_vers_test();
	(void) signal(SIGSYS, savsig);
	return ( ret==4?2:3 );
#endif

}
