/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	top_setup.c,v $
 * Revision 2.2  93/05/31  16:04:37  mrt
 * 	RCS-ed.
 * 	[93/05/08            af]
 * 
 */
/*
 * Copyright (C) 1990 Regents of the University of California.
 * Permission to use, copy, and distribute verbatim copies of this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice appears in all
 * copies.  Permission is granted to copy and distribute modified versions
 * of this software under the conditions for verbatim copying, provided
 * that the entire resulting derived work is distributed under the terms
 * of a permission notice identical to this one.  The University of
 * California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

# include <X11/Intrinsic.h>
# include <X11/StringDefs.h>
# include <X11/Shell.h>
# include <X11/Xaw/Form.h>

# include <stdio.h>

# include "cdrom_globs.h"
# include "debug.h"

XtAppContext	appc;
char		*file;
Boolean		display_timer	= True;
# if defined(notdef)
float		volbase		= 0;
# endif /* defined(notdef) */

static Widget	top_shell;
static Widget	top_form_widget;

static XrmOptionDescRec options[] = {
{ "-file",	".file",	XrmoptionSepArg,	(caddr_t) NULL },
{ "-debug",	".debug",	XrmoptionNoArg,		(caddr_t) "True" },
{ "-displayTimer", ".displayTimer", XrmoptionNoArg,	(caddr_t) "True" },
# if defined(notdef)
{ "-volBase",	".volBase",	XrmoptionSepArg,	(caddr_t) 0 },
# endif /* defined(notdef) */
};

static XtResource	resources[] = {
	{ "file", "File", XtRString, sizeof(String), (Cardinal) &file,
		  XtRString, (caddr_t) NULL },
	{ "debug", "Debug", XtRBoolean, sizeof(Boolean), (Cardinal) &debug,
		  XtRBoolean, (caddr_t) &debug },
	{ "displayTimer", "DisplayTimer", XtRBoolean, sizeof(Boolean),
		  (Cardinal) &display_timer, XtRBoolean,
		  (caddr_t) &display_timer },
# if defined(notdef)
	{ "volBase", "VolBase", XtRFloat, sizeof(float),
		  (Cardinal) &volbase, XtRFloat, (caddr_t) &volbase },
# endif /* defined(notdef) */
};

Widget
top_setup(argc, argv)
	int			argc;
	char			**argv;
{
	Display			*dpy;

	XtToolkitInitialize();

	appc = XtCreateApplicationContext();

	dpy = XtOpenDisplay(appc, NULL, "xcdplayer", "XCdplayer",
			    options, XtNumber(options),
			    (Cardinal *) &argc, argv);

	if (dpy == NULL) {
		fprintf(stderr, "can't open display\n");
		exit(1);
	}

	top_shell = XtAppCreateShell("xcdplayer", "XCdplayer",
				     applicationShellWidgetClass,
				     dpy, (ArgList) NULL, 0);

	(void) XtGetApplicationResources(top_shell, (caddr_t) NULL,
					 resources, XtNumber(resources),
					 (ArgList) NULL, 0);

	top_form_widget = XtCreateWidget("mainForm", formWidgetClass,
						 top_shell,
						 (ArgList) NULL, 0);

	return(top_form_widget);
}

void
top_start() {
	XtManageChild(top_form_widget);
	XtRealizeWidget(top_shell);
}
