/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	shuffle.c,v $
 * Revision 2.2  93/05/31  16:04:25  mrt
 * 	RCS-ed.
 * 	[93/05/08            af]
 * 
 */
/*
 * Copyright (C) 1990 Regents of the University of California.
 * Permission to use, copy, and distribute verbatim copies of this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice appears in all
 * copies.  Permission is granted to copy and distribute modified versions
 * of this software under the conditions for verbatim copying, provided
 * that the entire resulting derived work is distributed under the terms
 * of a permission notice identical to this one.  The University of
 * California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

# include <X11/Intrinsic.h>
# include <stdio.h>

# include "debug.h"
# include "cdrom_globs.h"
# include "cdrom_callb.h"

# define ran(min, max)  ((random() % ((max) - (min))) + (min))

static unsigned char	*random_tracks;

void
shuffle_setup() {
	extern char	*malloc();
	extern long	time();
	extern long	random();
	unsigned long	seed, now;
	char		state[128];
	int		try;
	int		i, j;

	if (cdi.cdi_maxtrack == cdi.cdi_mintrack) {
		cdi.cdi_currand = -1;
		return;
	}

	cdi.cdi_ntracks = (cdi.cdi_maxtrack - cdi.cdi_mintrack) + 1;

	cdi.cdi_currand = 0;

	if (random_tracks != NULL) {
		free(random_tracks);
		random_tracks = NULL;
	}

	if ((random_tracks = (unsigned char *) malloc(cdi.cdi_ntracks)) == NULL) {
		perror("malloc");
		exit(1);
	}

	now = time((long *) 0);
	seed = now & 0xfff;

	initstate(seed, state, sizeof(state));

	/*
	 * set up the random_tracks array
	 */
	for (i = 0; i < cdi.cdi_ntracks; i++) {
		for (;;) {
			try = ran(cdi.cdi_mintrack, cdi.cdi_maxtrack+1);

			if (i == 0)
				break;

			for (j = 0; j < i; j++) {
				if (random_tracks[j] == try)
					goto again;
			}

			/* not a repeat */
			break;

			again:;
		}

		random_tracks[i] = try;
	}

	if (debug == True) {
		debug_printf(1, "shuffle_setup: ");
		for (i = 0; i < cdi.cdi_ntracks; i++)
			debug_printf(1, "%d ", random_tracks[i]);
		debug_printf(1, "\n");
	}
}

unsigned char
shuffle_next_track() {
	if (cdi.cdi_currand == -1)
		return(cdi.cdi_mintrack);

	if (cdi.cdi_currand == cdi.cdi_ntracks) {
		fprintf(stderr, "shuffle_get_track: ran off end\n");
		return(cdi.cdi_mintrack);
	}

	return(random_tracks[cdi.cdi_currand++]);
}

unsigned char
shuffle_prev_track() {
	if (cdi.cdi_currand == -1)
		return(cdi.cdi_mintrack);

	cdi.cdi_currand -= 2;

	if (cdi.cdi_currand < 0)
		cdi.cdi_currand = 0;

	return(random_tracks[cdi.cdi_currand++]);
}
