/* 
 * Mach Operating System
 * Copyright (c) 1991,1990,1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	cdrom_callb.h,v $
 * Revision 2.2  93/05/31  16:02:52  mrt
 * 	RCS-ed.
 * 	[93/05/08            af]
 * 
 */
/*
 * Copyright (C) 1990 Regents of the University of California.
 * Permission to use, copy, and distribute verbatim copies of this
 * software and its documentation for any purpose and without fee is
 * hereby granted, provided that the above copyright notice appears in all
 * copies.  Permission is granted to copy and distribute modified versions
 * of this software under the conditions for verbatim copying, provided
 * that the entire resulting derived work is distributed under the terms
 * of a permission notice identical to this one.  The University of
 * California makes no representations about the suitability of this
 * software for any purpose.  It is provided "as is" without express or
 * implied warranty.
 */

# define bit(n)			(1 << (n))

/* bits for cdrom_state */
# define CDROM_STATE_PLAY	bit(0)
# define CDROM_STATE_PAUSE	bit(1)
# define CDROM_STATE_EJECTED	bit(2)
# define CDROM_STATE_CYCLE	bit(3)
# define CDROM_STATE_SHUFFLE	bit(4)

/* return codes from cdrom_status() */
# define CDROM_INVALID		1
# define CDROM_PLAYING		2
# define CDROM_PAUSED		3
# define CDROM_COMPLETED	4
# define CDROM_ERROR		5
# define CDROM_NO_STATUS	6

#define	STILL_MOUNTED	1
#define	UNMOUNTED	0

typedef struct _cdrom_info {
	unsigned char	cdi_curtrack;	/* current track playing	*/
	unsigned char	cdi_mintrack;	/* first audio track		*/
	unsigned char	cdi_maxtrack;	/* last audio track		*/
	unsigned char	cdi_ntracks;	/* size of random track list	*/
	unsigned short	*cdi_times;	/* duration of each track	*/
	unsigned int	cdi_dur;	/* seconds played so far	*/
	int		cdi_state;	/* state of cd-rom drive	*/
	short		cdi_currand;	/* index into random track list */
} cdrom_info;

extern void		cdrom_close();
extern int		cdrom_open();
extern int		cdrom_start();
extern int		cdrom_stop();
extern int		cdrom_eject();
extern int		cdrom_play_track();
extern int		cdrom_read_tocentry();
extern int		cdrom_read_tochdr();
extern int		cdrom_lock_unlock();
extern int		cdrom_pause();
extern int		cdrom_resume();
extern int		cdrom_volume();
extern int		cdrom_play();
extern int		cdrom_paused();
extern int		cdrom_status();
extern int		cdrom_get_curtrack();
extern int		cdrom_get_msf();
extern int		cdrom_get_times();
extern unsigned long	cdrom_get_relmsf();

extern cdrom_info	cdi;
