/* 
 * Mach Operating System
 * Copyright (c) 1993,1992 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	uxmon.c,v $
 * Revision 2.2  93/04/14  12:05:28  mrt
 * 	Created.
 * 	[93/04/14            rvb]
 * 
 */
/*
 * uxmon -- control unix server monitoring
 */

#include <stdio.h>
#include <strings.h>
#include <mach.h>

mach_port_t bsd_server_port;

/* global vars set by program args */
int ux_mon_state;
char *gmon_out;

/* from bsd_1_user.o */
extern int bsd_mon_switch();
extern int bsd_mon_dump();

void
usage(name)
	char *name;
{
	printf("usage: %s [on|off] [gmon file]\n", name);
}

void
parse_args(argc, argv)
	int argc;
	char **argv;
{
	/* first arg is on or off? */
	if (strcmp(argv[1], "on") == 0)
		ux_mon_state = 1;
	else if (strcmp(argv[1], "off") == 0)
		ux_mon_state = 0;
	else
		goto parse_fail;
	
	if (argc > 2) {
		/* if first arg is "off", second arg is dump file */
		if (ux_mon_state)
			goto parse_fail; /* 1st arg wasn't "off" */

		gmon_out = argv[2];
	}
	else
		gmon_out = (char *)NULL;
	return;

    parse_fail:
	usage(argv[0]);
	exit(1);
}


main(argc, argv)
	int argc;
	char **argv;
{
	kern_return_t kr;
	boolean_t intr;

	intr = FALSE;

	if (argc < 2) {
		usage(argv[0]);
		exit(0);
	}

	parse_args(argc, argv);

	/* bootstrap port is the unix server */
	kr = task_get_bootstrap_port(mach_task_self(), &bsd_server_port);
	if (kr != KERN_SUCCESS) {
		mach_error("getting bsd port", kr);
		exit(1);
	}

	printf("%s: setting ux monitor state to %d\n", argv[0], ux_mon_state);
	
	kr = bsd_mon_switch(bsd_server_port, &intr, &ux_mon_state);
	if (kr != KERN_SUCCESS) {
		mach_error("bsd_mon_switch", kr);
		exit(1);
	}

	printf("%s: ux monitor state was %d\n", argv[0], ux_mon_state);

	if (gmon_out != (char *) NULL) {
		char *mon_data;
		int mon_data_cnt;
		FILE *f;

		intr = FALSE;
		kr = bsd_mon_dump(bsd_server_port, &intr, &mon_data, &mon_data_cnt);
		if (kr != KERN_SUCCESS) {
			mach_error("bsd_mon_switch", kr);
			exit(1);
		}

		f = fopen(gmon_out, "w");
		if (f == (FILE *)NULL) {
			perror("fopen");
			exit(1);
		}
		
		kr = fwrite(mon_data, sizeof(char), mon_data_cnt, f);
		if (kr != mon_data_cnt) {
			perror("fwrite");
			exit(1);
		}
		fclose(f);
		printf("%s: monitoring data written to %s\n", argv[0], gmon_out);
	}
	exit(0);
}
