.\"
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie the
.\" rights to redistribute these changes.
.\"
.\" HISTORY
.\" $Log:	snames.man,v $
.\" Revision 2.4  92/11/13  17:38:26  mrt
.\" 	Added explanation on nmmonitor port.
.\" 	[92/11/11            mrt]
.\" 
.\" Revision 2.3  91/03/19  12:40:13  mrt
.\" 	Changed to new copyright
.\" 
.\" Revision 2.2  90/09/12  16:34:00  rpd
.\" 	Initial check-in.
.\" 	[90/09/12  15:53:35  rpd]
.\" 
.TH  SNAMES  1 6/18/90
.CM 4
.SH NAME
snames \- simple name server
.SH SYNOPSIS
\fBsnames\fP [\fB-d\fP] [command args...]
.SH DESCRIPTION
\fIsnames(1)\fR is a simple server implementing the netname name service.
It is like a netmsgserver which doesn't know about networks.
.PP
By default, \fIsnames\fR tries to become the primary name service
for the machine.  In this mode, it takes no arguments.
Being the primary name service means that it is the server that
receives messages sent to \fBname_server_port\fR. This is the same
port the netmsgserver uses when it is running.
If \fIname_server_port\fR is already in use, \fIsnames\fR 
becomes a secondary name service.
In this mode, it takes a command (often a shell) to run under
the secondary name service.
.PP
\fIsnames\fR interprets the following options:
.TP 8
.B \-d
Turns on debugging.  \fIsnames\fR will print informative messages
to stderr when clients register and lookup ports.
.PP
Calls to \fIsnames\fR are made on the \fBname_server_port\fR which is
a port that never dies and is inherited by each process as part of
the process initialization. \fIsnames\fR creates and checks in a port
named \fBnmmonitor\fR. This port will be destroyed if \fIsnames\fR 
dies which will cause a \fIdead_port_name\fR notification to be sent
to any holders of this port. This mechanism allows clients who have 
checked in service ports to know if \fIsnames\fR  has died and
to attempt to re-establish their ports with another name server.

.SH "SEE ALSO"
net_name_checkin(3), net_name_checkout(3), net_name_lookup(3),
net_name_version(3), mach_init(3), netmsgserver(8).
