.\" 
.\" HISTORY
.\" $Log:	mt.man,v $
.\" Revision 2.2  93/05/31  15:52:18  mrt
.\" 	First checkin.
.\" 
.\" 
.\" Revision 2.1.1.1  93/05/08  11:54:21  af
.\" 	Created from BNR man page.
.\" 	[93/05/08            af]
.\" 
.\"
.\" Copyright (c) 1981, 1990 The Regents of the University of California.
.\" All rights reserved.
.\"
.\" Redistribution and use in source and binary forms, with or without
.\" modification, are permitted provided that the following conditions
.\" are met:
.\" 1. Redistributions of source code must retain the above copyright
.\"    notice, this list of conditions and the following disclaimer.
.\" 2. Redistributions in binary form must reproduce the above copyright
.\"    notice, this list of conditions and the following disclaimer in the
.\"    documentation and/or other materials provided with the distribution.
.\" 3. All advertising materials mentioning features or use of this software
.\"    must display the following acknowledgement:
.\"	This product includes software developed by the University of
.\"	California, Berkeley and its contributors.
.\" 4. Neither the name of the University nor the names of its contributors
.\"    may be used to endorse or promote products derived from this software
.\"    without specific prior written permission.
.\"
.\" THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
.\" ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
.\" IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
.\" ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
.\" FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
.\" DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
.\" OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
.\" HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
.\" LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
.\" OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
.\" SUCH DAMAGE.
.\"
.\"     @(#)mt.1	6.6 (Berkeley) 3/14/91
.\"
.Vx
.Vx
.Dd March 14, 1991
.Os
.Dt MT 1
.Os BSD 4
.Sh NAME
.Nm mt
.Nd magnetic tape manipulating program
.Sh SYNOPSIS
.Nm mt
.Op Fl f Ar tapename
.Ar command
.Op Ar count
.Sh DESCRIPTION
.Nm Mt
is used to give commands to a magnetic tape drive.
If a tape name is not specified, the environment variable
.Ev TAPE
is used;  if
.Ev TAPE
does not exist,
.Nm mt
uses the kernel device
.Pa tz0 .
Note
that
.Ar tapename
must reference a Mach device, not a Unix filename.
By default
.Nm mt
performs the requested operation once.  Operations
may be performed multiple times by specifying
.Ar count  .
.Pp
The available commands are listed below.  Only as many
characters as are required to uniquely identify a command
need be specified.
.Tp Cm eof , weof
Write
.Ar count
end-of-file marks at the current position on the tape.
.Tp Cm fsf
Forward space
.Ar count
files.
.Tp Cm fsr
Forward space
.Ar count
records.
.Tp Cm bsf
Back space
.Ar count
files.
.Tp Cm bsr
Back space
.Ar count
records.
.Tp Cm rewind
Rewind the tape
(Count is ignored).
.Tp Cm offline , rewoffl
Rewind the tape and place the tape unit off-line
(Count is ignored).
.Tp Cm status
Print status information about the tape unit.
.Tp Cm density
Sets the tape density to the indicated value (count).
This value has device specific meanings.
.Tp Cm speed
Sets the tape speed to the indicated value (count).
This value has device specific meanings.
.Tp
.Pp
.Nm Mt
returns a 0 exit status when the operation(s) were successful,
1 if the command was unrecognized, 2 if a Unix operation failed,
a Mach error code (greater than 2) if a Mach call failed.
.Sh ENVIRONMENT
If the following environment variable exists, it is utilized by
.Nm mt .
.Tw Fl
.Tp Ev TAPE
.Nm Mt
checks the
.Ev TAPE
environment variable if the
argument
.Ar tapename
is not given.
.Sh SEE ALSO
.\".Xr mtio 4 ,
.Xr dd 1 ,
.Xr ioctl 2 ,
.Xr environ 7
.Sh HISTORY
.Nm Mt
appeared in 4.3 BSD.
.\" mt.1: mtio(4) missing
