.\"
.\" Mach Operating System
.\" Copyright (c) 1991,1990 Carnegie Mellon University
.\" All Rights Reserved.
.\" 
.\" Permission to use, copy, modify and distribute this software and its
.\" documentation is hereby granted, provided that both the copyright
.\" notice and this permission notice appear in all copies of the
.\" software, derivative works or modified versions, and any portions
.\" thereof, and that both notices appear in supporting documentation.
.\" 
.\" CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
.\" CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
.\" ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
.\" 
.\" Carnegie Mellon requests users of this software to return to
.\" 
.\"  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
.\"  School of Computer Science
.\"  Carnegie Mellon University
.\"  Pittsburgh PA 15213-3890
.\" 
.\" any improvements or extensions that they make and grant Carnegie the
.\" rights to redistribute these changes.
.\"
.\" HISTORY
.\" $Log:	monctl.man,v $
.\" Revision 2.2  93/08/11  14:41:56  mrt
.\" 	Created.
.\" 	[93/08/06            bershad]
.\" 
.\" 
.\" 
.TH  MONCTL  1 6/1/93
.CM 4
.SH NAME
monctl \- control monitoring/profiling of applications and the Unix server
.SH SYNOPSIS
\fBmonctl\fP [-pid PID]  [-host hostname] [-status] [-on periodic vmzfill vmpagein vmcow vmfaults] -off [-monfile filename] [-execfile filename]

.SH DESCRIPTION
\fImonctl(1)\fR allows profiling service to be controlled at a
distance for any application using the Mach (g)profiling
facilities.  The target process is specified by its Unix pid, and optional
hostname.  If no hostname is specified, the local host is assumed.
(Profiling a remote host requires that the remote host be running the
netmsgserver; snames is not sufficient).

.PP 
PID 0 is designated as the UX server.  Other PIDs may either be
that of Unix processes which have been compiled and linked for
profiling, or ANY Unix process (see -proxy below).

.PP
The options \fBperiodic, vmzfill, vmpagein, vmcow, vmfaults\fP specify
which kernel events should generate a PC sample record. The special
option \fPvmfaults\fP is the combination of all other vm events.
Kernel events are tagged with their type, but if the output from
\fBmonctl\fP is input to \fPgprof\fP, then it is not wise to mix
periodic and non-periodic events in the same trace.

.PP
"\fBmonctl\fP \fB-off\fP" turns profiling off.  

.PP
"\fBmonctl\fP \fB-status\fP" returns the current profiling status of the
target.

.PP
"\fBmonctl\fP \fB-monfile filename\fP" dumps
the profiling pc histogram and function call entry
counts into the named file.  This file may then be directly used 
by \fBgprof\fP to produce
a detailed analysis of the profiled program's activities.

.PP
"\fBmonctl\fP \fB-proxy" starts up the program as a proxy, collecting PC
sampling information for the target PID.  This option is intended to be used in
cases where the target has not been compiled for profiling.  No call graph
information will be collected, but the sampling information is sufficient for
input to gprof.

.PP
"\fBmonctl\fP \fB-execfile filename" must be used in conjunction with the
-proxy option.  The specified exec file is used to control the size of the
proxy's internal PC sampling tables.  This file should be the same on that is
later provided as input to gprof.

.SH "SEE ALSO"
gprof(1)

.SH "FILES"
libprof1.a -- the profiling routines

.SH BUGS
It is not possible to enable/disable profiling for the UNIX server (pid 0) on
any but the local host.  It's also not possible to spawn a proxy for processes
other than those on the local host.  We should probably use Mach IDs, rather
than Unix PIDs here.

