/* 
 * Mach Operating System
 * Copyright (c) 1993-1989 Carnegie Mellon University
 * All Rights Reserved.
 * 
 * Permission to use, copy, modify and distribute this software and its
 * documentation is hereby granted, provided that both the copyright
 * notice and this permission notice appear in all copies of the
 * software, derivative works or modified versions, and any portions
 * thereof, and that both notices appear in supporting documentation.
 * 
 * CARNEGIE MELLON ALLOWS FREE USE OF THIS SOFTWARE IN ITS 
 * CONDITION.  CARNEGIE MELLON DISCLAIMS ANY LIABILITY OF ANY KIND FOR
 * ANY DAMAGES WHATSOEVER RESULTING FROM THE USE OF THIS SOFTWARE.
 * 
 * Carnegie Mellon requests users of this software to return to
 * 
 *  Software Distribution Coordinator  or  Software.Distribution@CS.CMU.EDU
 *  School of Computer Science
 *  Carnegie Mellon University
 *  Pittsburgh PA 15213-3890
 * 
 * any improvements or extensions that they make and grant Carnegie the
 * rights to redistribute these changes.
 */
/*
 * HISTORY
 * $Log:	audio_record.c,v $
 * Revision 2.2  93/05/31  15:59:03  mrt
 * 	Rewritten and RCS-ed.
 * 	[93/05/10            af]
 * 
/*
 *	Program: audio_play
 *	Author: Jeff Baird
 *		Mach-ized by af@mach.cs.cmu
 *	Date: ?/1989
 *
 *	Create a file of audio samples.
 */

#include <sys/types.h>
#include <sys/file.h>

#include <errno.h>
#include <stdio.h>
#include <sys/ioctl.h>

#include <mach.h>
#include <device/device_types.h>
#include <device/audio_status.h>

#include <string.h>

mach_port_t	Audio_Port;

main(argc,argv)
	int	argc;
	char	*argv[];
{
	struct audio_ioctl tmp;
	mach_port_t     device_server_port;
	io_return_t     rc;

	device_server_port = task_by_pid(-2);
	if (device_server_port == MACH_PORT_NULL) {
		errno = EPERM;
		perror("Getting device_server_port: ");
		return -1;
	}
	rc = device_open(device_server_port, 0, "audio0", &Audio_Port);
	if (rc != D_SUCCESS) {
		mach_error("audio0:", rc);
		return -1;
	}
	for (argc--, argv++; argc-- > 0; argv++) {
		if (!*argv) {
			break;
		} else if (*argv[0] == '-') {
			set_volume(atoi(argv[1]));
			argv++;
		} else {
			copy_to_file(Audio_Port, argv[0]);
		}
	}
	device_close(Audio_Port);
}

copy_to_file(port, name)
     mach_port_t port;
     char *name;
{
	natural_t       namefd, cnt;
	char           *buf;

	if ((namefd = open(name, O_WRONLY|O_CREAT, 0644)) < 0) {
		perror(name);
		return;
	}
	while (1) {
		cnt = vm_page_size;
		if (device_read(Audio_Port, 0, 0, cnt, &buf, &cnt))
			break;
		if (write(namefd, buf, cnt) != cnt)
			break;
	}
	close(namefd);
}


set_volume(value)
	int		value;
{
	io_return_t     rc;
	audio_info_t	ai;

	AUDIO_INITINFO(&ai);

	value &= 0xff;
	/* so I cannot set it to the true max ah ? */
	if (value == 0xff) value -= 1;

	ai.record.gain = value;

	rc = device_set_status(Audio_Port, AUDIO_SETINFO, &ai, sizeof(ai) / sizeof(int));
	if (rc != D_SUCCESS) {
		mach_error("Set Volume:", rc);
	}
}

