/* view3d.h */

#ifndef VIEW3d__H
#define VIEW3d__H

#include <coriolis/kernel.h>
#include <LEDA/point.h>
#include <LEDA/window.h>
#include "common.h"

void activate_gfx( void ); /* initially no graphics */
bool gfx_on( void ); /* true if graphics activated */

const bool DRAW_GL = false;

/* in leda's coord system a window at ( 0, 0 ) in top_left, and is disp_size
   high/wide */
const double disp_size = 100;

/* dc_view 
   - views are just a window and a camera position, and calls to draw shape
   update each view every time the coriolis agent is advanced
   - right now there is one main view and a view is associated with each object
   - later, jchuang needs to allow user to open a view for an object from the
   gui */
class dc_view {
private:
  triple *wpos;
  matrix R; /* rotation matrix -- coriolis matrix, not newmat Matrix */
  
  window *view_window;
  string view_name;

  int screen_wid;
  int screen_hgt;

  list_item li;
public:
  double world_wid;
  double world_hgt;

  dc_view( void );
  dc_view( cstring s, triple &p, const matrix &r = matrix::unity(3) );
  ~dc_view( void );

  void init( cstring, triple &, const matrix & = matrix::unity(3) );

  void move_pov( ctriple );
  void get_pos( triple &pos, matrix &r ) const { pos = *wpos, r = R; }
  //void rotate( ctriple ); /* three thetas */
  void rotate( matrix &r );

  bool project( ctriple, point & );

  void draw_line( ctriple, ctriple, const color &C );
  /* this version used iff DRAW_GL == true. DRAW_GL defined at top of file. */
  void draw_poly( triple [], int npts, const matrix &r, ctriple x, 
		  const color &C );
  /* this version used iff DRAW_GL == false */
  void draw_poly( list<triple> &, const color &C );

  void clear( void ) { if( view_window ) view_window->clear(); }

  void set_label( cstring label );

  friend void activate_gfx( void );
};

extern list<dc_view *> view_list; /* do not remove or add to this list */

#endif
