/* vector.h */

#ifndef VECTOR__H
#define VECTOR__H

#include "matrix.h"

class dc_vector : public dc_matrix {
protected:
  ColumnVector val;
  
  void touch( void ); /* checks validity after operations */
public:
  dc_vector();
  dc_vector( const int n, const string &label = "", dc_node *parent = nil );
  dc_vector( const ColumnVector &V, const string &label = "", 
	     dc_node *parent = nil );
  dc_vector( const string &label, dc_node *parent = nil );
  ~dc_vector();
  
  /* inherited functions */
  const dc_type sub_type( void ) const { return Vector_t; }
  string type_string( void ) const { return valid ? string( "vector:%d", 
				   val.Nrows() ) : string( "invalid vector" ); }
  
  /* input, output, and assignment operators */
  dc_vector &operator=( const ColumnVector &V );
  dc_vector &operator=( const RowVector &V );
  dc_vector &operator=( dc_data &D );

  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_vector &V ) { 
    return V.display_c( stream );
  }
  friend istream &operator>>( istream &stream, dc_vector &V );

  /* indexing start at 1 */
  Real operator()( const int i ) const { return val( i ); }

  /* functions to access Col/Row */
  ReturnMatrix get( void );
  ReturnMatrix get_as_col( void ) { return get(); }
  ReturnMatrix get_as_row( void );
  void set( const ColumnVector &V );
  void set_row( const RowVector &V );
  void set( dc_vector &V );
  void set( const double d[] );
  void resize( const int d );
  int dim( void ) const { return val.Nrows(); }
  /* Nrows, Ncols depend on column vector */
  int Nrows( void ) const { return val.Nrows(); }
  int Ncols( void ) const { return 1; }
  
  /* returns location of vectors array.  do not delete */
  Real *get_store( void ) const { return val.Store(); }
  int get_storage( void ) const { return val.Storage(); }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif
