/* types.h */

/* this header defines types for all descendants of dc_common */

#ifndef DC_TYPES__H
#define DC_TYPES__H

               /* base types - should not be seen in actual objects since 
		  overridden by descendants */
enum dc_type { Undef_t = 0, Label_t, Node_t, Generic_t,
	       
	       /* data types */
	       Data_t, /* Data_t used as generic data_type in castings or for 
			  parsing functions where no return type is specified */

	       /* simple data types */
	       Boolean_t, Int_t, Real_t,
	       
	       /* real subtypes */
	       Distrib_t,

	       /* matrix type */
	       Matrix_t, 

	       /* matrix subtypes */
	       Rect_Matrix_t, Vector_t, Triple_t,

	       /* pointer type */
	       Pointer_t,

	       /* label set type */
	       Set_t,

	       /* string type */
	       String_t,

	       /* symbolic_type */
	       Symbol_t,

	       /* coriolis data types */
	       Shape_t,

	       /* component subtype - a subtype of node */
	       Component_t,

	       /* modification - a subtype of component */
	       Modification_t,

	       /* genetic algorithm - a subtype of component */
	       GA_t,

	       /* element type */
	       Element_t, 

	       /* clock */
	       Clock_t };

/* this string array mapped to by dc_type */
const char *const dc_type_string[] = { "undefined", "label", "node", "generic",
				       "generic data", "boolean", "int",
				       "real", "distrib",
				       "generic matrix", "matrix",
				       "vector", "triple",
				       "pointer", "set", "string", 
				       "symbol", "shape",
				       "component", "modification", "ga",
				       "element", "clock"
};

/* if no type is specified for element or function return type, parser assumes 
   this type */
const dc_type default_type = Real_t;

/* true if type from can be cast to type to by cast( dc_data &, const dc_type )
   defined in data.cc */
bool castable( dc_type from, dc_type to );

#endif
