/* string.h */

#ifndef STRING__H
#define STRING__H

#include "data.h"
#include <LEDA/basic.h>

class dc_string : public dc_data {
private:
  string val;
  
public:
  dc_string( void ) { ; }
  dc_string( cstring s ) { val = s; }   /* creates temporary */

  dc_string( cstring, cstring, dc_node *parent );

  /* inherited functions */
  const dc_type type( void ) const { return String_t; }
  string type_string( void ) const { return string( "string" ); }
  
  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_string &S ) {
    return S.display_c( stream );
  }
  friend istream &operator>>( istream &stream, dc_string &S );

  /* do not perform temporary cleanup */
  bool operator==( dc_string &s );
  bool operator!=( dc_string &s );
  bool operator<( dc_string &s );
  bool operator>( dc_string &s );
  bool operator<=( dc_string &s );
  bool operator>=( dc_string &s );
  dc_string &operator+( dc_string &s );
  dc_string &operator+=( dc_string &s );
  dc_string &operator=( dc_string &s );

  /* functions to access val */
  string get( void ) const { return val; }
  void set( cstring s ) { val = s; }

  /* set_parsed will replace "\n", "\r", "\\", "\"", "\'", "\0' in s */
  void set_parsed( cstring s );
  void set( const dc_string &S ) { val = S.get(); }
  int length( void ) const { return val.length(); }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif
