/* real.h */

#ifndef REAL__H
#define REAL__H

#include "udata.h"

class dc_real : public dc_udata {
protected:
  double val;

public:
  dc_real( const double R = 0.0 );
  dc_real( const double R, const string &label, dc_node *parent = nil );

  /* inherited functions */
  const dc_type type( void ) const { return Real_t; }
  string type_string( void ) const { return string( "real" ); }

  /* input, output, and assignment operators */
  dc_real &operator=( dc_data &D );
  dc_real &operator=( const double d );

  ostream &display( ostream &stream = cout ){ return display_c( stream ); }
  ostream &display_c( ostream &stream = cout ) const;
  friend ostream &operator<<( ostream &stream, const dc_real &R ) { 
    return R.display_c( stream ); 
  }
  friend istream &operator>>( istream &stream, dc_real &R );

  /* functions to access val */
  double get( void ) const { return val; }
  void set( const double v ) { val = v; }

  dc_label *duplicate( dc_node *parent ) const;
};

#endif



