/* real.cc */

#include "real.h"
#include "integer.h"

dc_real::dc_real( const double R = 0.0 ) {
  val = R;
  valid = true;
}

dc_real::dc_real( const double R, const string &label, dc_node *parent = nil ) {
  val = R;
  set_both( label, parent );
}

dc_real &dc_real::operator=( const double d ) {
  val = d;
  return *this;
}

dc_real &dc_real::operator=( dc_data &D ) {
  if( D.type() == Real_t ) {
    val = ( ( dc_real * ) &D )->val;
    units = ( ( dc_real * ) &D )->get_units();
  } else if( D.type() == Int_t ) {
    val = ( double )( ( dc_int * ) &D )->get();
    units = ( ( dc_int * ) &D )->get_units();
  } else {
    cerr << "dc_integer::operator= -- cannot assign " << D.type_string() 
	 << " to " << type_string() << "\n";
  }
  if( D.is_temporary() ) delete( &D );
  return *this;
} 

ostream &dc_real::display_c( ostream &stream = cout ) const {
  stream << val << units;
  return stream;
}

dc_label *dc_real::duplicate( dc_node *parent ) const {
  dc_real *dupe = new dc_real( val );
  dupe->set_units( get_units_c() );

  if( !is_temporary() ) {
    if( dupe->set_both( local_label(), parent ) ) {
      delete( dupe );
      return nil;
    }
  }
  dupe->set_visible( is_visible() );
  return ( dc_label * )dupe;
}

istream &operator>>( istream &stream, dc_real &R ) {
  stream >> R.val;
  return stream;
}
