/* matrix.h */

#ifndef MATRIX__H
#define MATRIX__H

#include <matrix/newmatio.h>
#include <matrix/newmatnl.h>
#include "udata.h"

/* abstract base matrix class */
class dc_matrix : public dc_udata {
public:
  /* inherited functions */
  const dc_type type( void ) const { return Matrix_t; }
  string type_string( void ) const { return string( "invalid matrix" ); }
  void get_xtype( xtype &xt ); /* source in rmatrix.cc */
  
  /* input, output, and assignment operators */
  virtual dc_matrix &operator=( dc_data &D ) = 0;

  virtual ReturnMatrix get( void ) = 0;
  virtual int Nrows( void ) const = 0;
  virtual int Ncols( void ) const = 0;

 /* returns location of vectors array.  do not delete */
  virtual Real *get_store( void ) const = 0;
  virtual int get_storage( void ) const = 0;
};

#endif




