/* ID.C */

#include<SYNERGY/ID.h>

 IDLabel::IDLabel(string localLabel, IDLabel *parentID)
{
  if (IDisLabel(localLabel)) ERROR (1,"Invalid SLASH in local label\n");
  this->parentID = parentID;
  this->localID = (parentID)?false:true;
  this->localLabel = localLabel;
}

 IDLabel::IDLabel(const IDLabel &ID)
{
  *this = ID;
}

 IDLabel::~IDLabel(void)
{
/*ID-Q?:Does C++ call destructors in a nested fashion, eg for strings in this class? */
}

IDLabel& IDLabel::operator=(const IDLabel &ID)
{
  localID = ID.localID;
  parentID = ID.parentID;
  localLabel = ID.localLabel;
  return(*this);
}

void IDLabel::display(void)
{
  return;
}

bool IDLabel::itIs(string label)
{
  return(label == this->label());
}

string IDLabel::label(void)
{
  return(localID?localLabel:IDaddChild(parentID->label(),localLabel));
}

// friend
ostream& operator<<(ostream& os, IDLabel &ID)
{
  os << ID.label();
  /*Q?: returning the above expression ought to return os, check and do it */
  return(os);
}
