 
#ifndef FORMULA_CLASS
#define FORMULA_CLASS

#include <iostream.h>
#include <strstream.h>
#include <math.h>
#include <LEDA/basic.h>
#include <LEDA/h_array.h>
#include <Component.h>

/* Q? need to Hash string */

class Formula{
 private:
  IDLabel id;
  string expression;
  static Component *Universe; 
  /* all components part of this Universe */
  static bool init(0);
  static int MaxNest = 10, MaxArgs = 25;
  static int MaxExpressionLen = 1000;
  static int J = 3;

  int *code, *bracket, nCode, nConsts, nBrackets;
  double *consts;
  int decode(const string &s);
  int parse(const string &s);
  int headTail (string &h, string &s); /* s contains data */
  
 public:
  Formula ();
  Formula (string expression);
  ~Formula();

  void set(const IDLabel &id);
  double evaluate(double *a);
  int addFormula(Formula *f);
}

#endif
